/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.killbill.commons.utils.annotation.VisibleForTesting;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class BeanMapper<T>
implements ResultSetMapper<T> {
    private final Class<T> type;
    private final Map<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();

    public BeanMapper(Class<T> type) {
        this.type = type;
        try {
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                this.properties.put(descriptor.getName().toLowerCase(), descriptor);
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    @Override
    public T map(int row, ResultSet rs, StatementContext ctx) throws SQLException {
        T bean;
        try {
            bean = this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("A bean, %s, was mapped which was not instantiable", this.type.getName()), e);
        }
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String name = metadata.getColumnLabel(i).toLowerCase();
            PropertyDescriptor descriptor = this.properties.get(name);
            if (descriptor == null) continue;
            Class<?> type = descriptor.getPropertyType();
            Object value = this.getValueFromResultSet(rs, type, i);
            Method method = descriptor.getWriteMethod();
            if (method == null) {
                throw new IllegalArgumentException(String.format("No appropriate method to write property %s", name));
            }
            try {
                descriptor.getWriteMethod().invoke(bean, value);
                continue;
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Unable to access setter for property, %s", name), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("Invocation target exception trying to invoker setter for the %s property", name), e);
            }
        }
        return bean;
    }

    @VisibleForTesting
    Object getValueFromResultSet(ResultSet rs, Class type, int index) throws SQLException {
        String str;
        Object result = type.isAssignableFrom(Boolean.class) || type.isAssignableFrom(Boolean.TYPE) ? Boolean.valueOf(rs.getBoolean(index)) : (type.isAssignableFrom(Byte.class) || type.isAssignableFrom(Byte.TYPE) ? Byte.valueOf(rs.getByte(index)) : (type.isAssignableFrom(Short.class) || type.isAssignableFrom(Short.TYPE) ? Short.valueOf(rs.getShort(index)) : (type.isAssignableFrom(Integer.class) || type.isAssignableFrom(Integer.TYPE) ? Integer.valueOf(rs.getInt(index)) : (type.isAssignableFrom(Long.class) || type.isAssignableFrom(Long.TYPE) ? Long.valueOf(rs.getLong(index)) : (type.isAssignableFrom(Float.class) || type.isAssignableFrom(Float.TYPE) ? Float.valueOf(rs.getFloat(index)) : (type.isAssignableFrom(Double.class) || type.isAssignableFrom(Double.TYPE) ? Double.valueOf(rs.getDouble(index)) : (type.isAssignableFrom(BigDecimal.class) ? rs.getBigDecimal(index) : (type.isAssignableFrom(Timestamp.class) ? rs.getTimestamp(index) : (type.isAssignableFrom(Time.class) ? rs.getTime(index) : (type.isAssignableFrom(Date.class) ? rs.getDate(index) : (type.isAssignableFrom(String.class) ? rs.getString(index) : (type.isEnum() ? ((str = rs.getString(index)) != null ? Enum.valueOf(type, str) : null) : rs.getObject(index)))))))))))));
        return rs.wasNull() && !type.isPrimitive() ? null : result;
    }
}

