/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.jdbi.mapper;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;
import org.killbill.commons.utils.Strings;
import org.skife.jdbi.v2.StatementContext;
import org.skife.jdbi.v2.tweak.ResultSetMapper;

public class LowerToCamelBeanMapper<T>
implements ResultSetMapper<T> {
    private final Class<T> type;
    private final Map<String, PropertyDescriptor> properties = new HashMap<String, PropertyDescriptor>();
    private final Map<String, PropertyMapper<ResultSet, ?>> propertiesMappers = new HashMap();

    public LowerToCamelBeanMapper(Class<T> type) {
        this.type = type;
        try {
            BeanInfo info = Introspector.getBeanInfo(type);
            for (PropertyDescriptor descriptor : info.getPropertyDescriptors()) {
                String key = Strings.toSnakeCase((String)descriptor.getName()).toLowerCase();
                this.properties.put(key, descriptor);
                PropertyMapper<ResultSet, ?> propertyMapper = LowerToCamelBeanMapper.getPropertyMapper(descriptor);
                this.propertiesMappers.put(key, propertyMapper);
            }
        }
        catch (IntrospectionException e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static PropertyMapper<ResultSet, ?> getPropertyMapper(PropertyDescriptor descriptor) {
        Class<Object> propertyType = descriptor.getPropertyType();
        PropertyMapper<ResultSet, Object> propertyMapper = propertyType.isAssignableFrom(Boolean.class) || propertyType.isAssignableFrom(Boolean.TYPE) ? ResultSet::getBoolean : (propertyType.isAssignableFrom(Byte.class) || propertyType.isAssignableFrom(Byte.TYPE) ? ResultSet::getByte : (propertyType.isAssignableFrom(Short.class) || propertyType.isAssignableFrom(Short.TYPE) ? ResultSet::getShort : (propertyType.isAssignableFrom(Integer.class) || propertyType.isAssignableFrom(Integer.TYPE) ? ResultSet::getInt : (propertyType.isAssignableFrom(Long.class) || propertyType.isAssignableFrom(Long.TYPE) ? ResultSet::getLong : (propertyType.isAssignableFrom(Float.class) || propertyType.isAssignableFrom(Float.TYPE) ? ResultSet::getFloat : (propertyType.isAssignableFrom(Double.class) || propertyType.isAssignableFrom(Double.TYPE) ? ResultSet::getDouble : (propertyType.isAssignableFrom(BigDecimal.class) ? ResultSet::getBigDecimal : (propertyType.isAssignableFrom(DateTime.class) ? (rs, i) -> {
            Timestamp timestamp = rs.getTimestamp(i);
            return timestamp == null ? null : new DateTime((Object)timestamp).toDateTime(DateTimeZone.UTC);
        } : (propertyType.isAssignableFrom(Time.class) ? ResultSet::getTime : (propertyType.isAssignableFrom(LocalDate.class) ? (rs, i) -> {
            String dateString = rs.getString(i);
            return dateString == null ? null : new LocalDate((Object)dateString, DateTimeZone.UTC);
        } : (propertyType.isAssignableFrom(DateTimeZone.class) ? (rs, i) -> {
            String dateTimeZoneString = rs.getString(i);
            return dateTimeZoneString == null ? null : DateTimeZone.forID((String)dateTimeZoneString);
        } : (propertyType.isAssignableFrom(String.class) ? ResultSet::getString : (propertyType.isAssignableFrom(UUID.class) ? (rs, i) -> {
            String uuidString = rs.getString(i);
            return uuidString == null ? null : UUID.fromString(uuidString);
        } : (propertyType.isEnum() ? (rs, i) -> {
            String enumString = rs.getString(i);
            return enumString == null ? null : Enum.valueOf(propertyType, enumString);
        } : (propertyType == byte[].class ? ResultSet::getBytes : (rs, i) -> (Time)rs.getObject(i))))))))))))))));
        return propertyMapper;
    }

    private static Field getField(Class<?> clazz, String fieldName) throws NoSuchFieldException {
        try {
            return clazz.getDeclaredField(fieldName);
        }
        catch (NoSuchFieldException e) {
            Class<?> superClass = clazz.getSuperclass();
            if (superClass == null) {
                throw e;
            }
            return LowerToCamelBeanMapper.getField(superClass, fieldName);
        }
    }

    @Override
    public T map(int row, ResultSet rs, StatementContext ctx) throws SQLException {
        T bean;
        try {
            bean = this.type.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("A bean, %s, was mapped which was not instantiable", this.type.getName()), e);
        }
        Class<?> beanClass = bean.getClass();
        ResultSetMetaData metadata = rs.getMetaData();
        for (int i = 1; i <= metadata.getColumnCount(); ++i) {
            String name = metadata.getColumnLabel(i).toLowerCase();
            PropertyMapper<ResultSet, ?> propertyMapper = this.propertiesMappers.get(name);
            if (propertyMapper == null) continue;
            Object value = propertyMapper.apply(rs, i);
            if (value instanceof Blob) {
                Blob blob = (Blob)value;
                value = blob.getBytes(1L, (int)blob.length());
            }
            if (rs.wasNull() && !this.type.isPrimitive()) {
                value = null;
            }
            try {
                PropertyDescriptor descriptor = this.properties.get(name);
                Method writeMethod = descriptor.getWriteMethod();
                if (writeMethod != null) {
                    writeMethod.invoke(bean, value);
                    continue;
                }
                String camelCasedName = Strings.toCamelCase((String)name, (boolean)false, (char[])new char[]{'_'});
                Field field = LowerToCamelBeanMapper.getField(beanClass, camelCasedName);
                field.setAccessible(true);
                field.set(bean, value);
                continue;
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("Unable to set field for property: name=%s, value=%s", name, value), e);
            }
            catch (NoSuchFieldException e) {
                throw new IllegalArgumentException(String.format("Unable to find field for property, %s", name), e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(String.format("Unable to access setter for property, %s", name), e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(String.format("Invocation target exception trying to invoker setter for the %s property", name), e);
            }
        }
        return bean;
    }

    protected static interface PropertyMapper<ResultSet, T> {
        public T apply(ResultSet var1, int var2) throws SQLException;
    }
}

