/*
 * Decompiled with CFR 0.152.
 */
package org.skife.jdbi.v2.sqlobject.stringtemplate;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.sql.SQLException;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizerFactory;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.sqlobject.stringtemplate.ST4StatementLocator;
import org.skife.jdbi.v2.tweak.StatementLocator;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.TYPE})
@SqlStatementCustomizingAnnotation(value=LocatorFactory.class)
public @interface UseST4StatementLocator {
    public static final String USE_SQLOBJECT_TYPE_INDICATOR = "$$# ^&&*% $$!$$";

    public String groupFile() default "$$# ^&&*% $$!$$";

    public boolean useTemplateGroupCache() default true;

    public static class LocatorFactory
    implements SqlStatementCustomizerFactory {
        private static SqlStatementCustomizer make(UseST4StatementLocator an, Class sqlObjectType) {
            StatementLocator locator;
            if (UseST4StatementLocator.USE_SQLOBJECT_TYPE_INDICATOR.equals(an.groupFile())) {
                locator = ST4StatementLocator.forType(sqlObjectType);
            } else {
                ST4StatementLocator.UseSTGroupCache useCache = an.useTemplateGroupCache() ? ST4StatementLocator.UseSTGroupCache.YES : ST4StatementLocator.UseSTGroupCache.NO;
                locator = ST4StatementLocator.fromClasspath(useCache, an.groupFile());
            }
            return new SqlStatementCustomizer(){

                @Override
                public void apply(SQLStatement q) throws SQLException {
                    q.setStatementLocator(locator);
                }
            };
        }

        @Override
        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            return LocatorFactory.make((UseST4StatementLocator)annotation, sqlObjectType);
        }

        @Override
        public SqlStatementCustomizer createForType(Annotation annotation, Class sqlObjectType) {
            return LocatorFactory.make((UseST4StatementLocator)annotation, sqlObjectType);
        }

        @Override
        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            throw new UnsupportedOperationException("Annotation cannot be applied to parameter");
        }
    }
}

