/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker;

import java.sql.Connection;
import java.sql.SQLException;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.locker.GlobalLockDao;
import org.killbill.commons.locker.ResetReentrantLockCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalLockBase
implements GlobalLock {
    private static final Logger logger = LoggerFactory.getLogger(GlobalLockBase.class);
    private final GlobalLockDao lockDao;
    private final Connection connection;
    private final String lockName;
    private final ResetReentrantLockCallback resetCallback;

    public GlobalLockBase(Connection connection, String lockName, GlobalLockDao lockDao, ResetReentrantLockCallback resetCallback) {
        this.lockDao = lockDao;
        this.connection = connection;
        this.lockName = lockName;
        this.resetCallback = resetCallback;
    }

    public void release() {
        if (this.resetCallback != null && !this.resetCallback.reset(this.lockName)) {
            return;
        }
        try {
            this.lockDao.releaseLock(this.connection, this.lockName);
        }
        catch (SQLException e) {
            logger.warn("Unable to release lock for " + this.lockName, (Throwable)e);
        }
        finally {
            try {
                this.connection.close();
            }
            catch (SQLException e) {
                logger.warn("Unable to close connection", (Throwable)e);
            }
        }
    }
}

