/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.locker.GlobalLockDao;
import org.killbill.commons.locker.GlobalLocker;
import org.killbill.commons.locker.LockFailedException;
import org.killbill.commons.locker.ReentrantLock;
import org.killbill.commons.locker.ResetReentrantLockCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlobalLockerBase
implements GlobalLocker {
    protected static final long DEFAULT_TIMEOUT_MILLIS = 100L;
    protected static final Logger logger = LoggerFactory.getLogger(GlobalLockerBase.class);
    protected final GlobalLockDao globalLockDao;
    protected final long timeout;
    protected final TimeUnit timeUnit;
    protected final ReentrantLock lockTable;
    private final DataSource dataSource;

    public GlobalLockerBase(DataSource dataSource, GlobalLockDao globalLockDao, long timeout, TimeUnit timeUnit) {
        this.dataSource = dataSource;
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.globalLockDao = globalLockDao;
        this.lockTable = new ReentrantLock();
    }

    public GlobalLock lockWithNumberOfTries(String service, String lockKey, int retry) throws LockFailedException {
        String lockName = this.getLockName(service, lockKey);
        int tries_left = retry;
        while (tries_left-- > 0) {
            GlobalLock lock = this.lock(lockName);
            if (lock != null) {
                return lock;
            }
            if (tries_left <= 0) continue;
            this.sleep();
        }
        logger.warn(String.format("Failed to acquire lock %s for service %s after %s retries", lockKey, service, retry));
        throw new LockFailedException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isFree(String service, String lockKey) {
        String lockName = this.getLockName(service, lockKey);
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            boolean bl = this.globalLockDao.isLockFree(connection, lockName);
            return bl;
        }
        catch (SQLException e) {
            logger.warn("Unable to check if lock is free", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn("Unable to close connection", (Throwable)e);
                }
            }
        }
    }

    protected GlobalLock lock(String lockName) throws LockFailedException {
        ReentrantLock.TryAcquireLockState lockState = this.lockTable.tryAcquireLockForExistingOwner(lockName);
        if (lockState.getLockState() == ReentrantLock.ReentrantLockState.HELD_OWNER) {
            return lockState.getOriginalLock();
        }
        if (lockState.getLockState() == ReentrantLock.ReentrantLockState.HELD_NOT_OWNER) {
            try {
                Thread.sleep(TimeUnit.MILLISECONDS.convert(this.timeout, this.timeUnit));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("lock got interrupted", (Throwable)e);
            }
            return null;
        }
        return this.doLock(lockName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected GlobalLock doLock(String lockName) {
        Connection connection = null;
        boolean obtained = false;
        try {
            connection = this.dataSource.getConnection();
            obtained = this.globalLockDao.lock(connection, lockName, this.timeout, this.timeUnit);
            if (obtained) {
                GlobalLock lock = this.getGlobalLock(connection, lockName, new ResetReentrantLockCallback(){

                    public boolean reset(String lockName) {
                        return GlobalLockerBase.this.lockTable.releaseLock(lockName);
                    }
                });
                this.lockTable.createLock(lockName, lock);
                GlobalLock globalLock = lock;
                return globalLock;
            }
        }
        catch (SQLException e) {
            logger.warn("Unable to obtain lock for {}", (Object)lockName, (Object)e);
        }
        finally {
            if (!obtained && connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn("Unable to close connection", (Throwable)e);
                }
            }
        }
        return null;
    }

    protected abstract GlobalLock getGlobalLock(Connection var1, String var2, ResetReentrantLockCallback var3);

    protected abstract String getLockName(String var1, String var2);

    private void sleep() {
        try {
            Thread.sleep(TimeUnit.MILLISECONDS.convert(this.timeout, this.timeUnit));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("GlobalLockerBase got interrupted", (Throwable)e);
        }
    }
}

