/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker.mysql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.killbill.commons.locker.GlobalLockDao;

public class MysqlGlobalLockDao
implements GlobalLockDao {
    public boolean lock(Connection connection, String lockName, long timeout, TimeUnit timeUnit) throws SQLException {
        String sql = String.format("select GET_LOCK('%s', %d);", lockName.replace("'", "'"), 0);
        return this.executeLockQuery(connection, sql);
    }

    public boolean releaseLock(Connection connection, String lockName) throws SQLException {
        String sql = String.format("select RELEASE_LOCK('%s');", lockName.replace("'", "'"));
        return this.executeLockQuery(connection, sql);
    }

    public boolean isLockFree(Connection connection, String lockName) throws SQLException {
        String sql = String.format("select IS_FREE_LOCK('%s');", lockName.replace("'", "'"));
        return this.executeLockQuery(connection, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeLockQuery(Connection connection, String query) throws SQLException {
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(query);
            boolean bl = rs.next() && rs.getByte(1) == 1;
            return bl;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }
}

