/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker.postgresql;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.locker.GlobalLocker;
import org.killbill.commons.locker.GlobalLockerBase;
import org.killbill.commons.locker.ResetReentrantLockCallback;
import org.killbill.commons.locker.postgresql.PostgreSQLGlobalLock;
import org.killbill.commons.locker.postgresql.PostgreSQLGlobalLockDao;

public class PostgreSQLGlobalLocker
extends GlobalLockerBase
implements GlobalLocker {
    public PostgreSQLGlobalLocker(DataSource dataSource) {
        this(dataSource, 100L, TimeUnit.MILLISECONDS);
    }

    public PostgreSQLGlobalLocker(DataSource dataSource, long timeout, TimeUnit timeUnit) {
        super(dataSource, new PostgreSQLGlobalLockDao(), timeout, timeUnit);
    }

    protected GlobalLock getGlobalLock(Connection connection, String lockName, ResetReentrantLockCallback resetCb) {
        return new PostgreSQLGlobalLock(connection, lockName, this.globalLockDao, resetCb);
    }

    protected String getLockName(String service, String lockKey) {
        String lockName = service + "-" + lockKey;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] bytes = messageDigest.digest(lockName.getBytes());
            return String.valueOf(ByteBuffer.wrap(bytes).getLong());
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Unable to allocate MessageDigest", (Throwable)e);
            return String.valueOf(lockName.hashCode());
        }
    }
}

