/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker;

import java.util.HashMap;
import java.util.Map;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.request.Request;
import org.killbill.commons.request.RequestData;

public class ReentrantLock {
    private final Map<String, LockHolder> lockTable = new HashMap<String, LockHolder>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TryAcquireLockState tryAcquireLockForExistingOwner(String lockName) {
        Map<String, LockHolder> map = this.lockTable;
        synchronized (map) {
            LockHolder lockHolder = this.lockTable.get(lockName);
            if (lockHolder == null) {
                return new TryAcquireLockState(ReentrantLockState.FREE);
            }
            String maybeNullRequestId = this.getRequestId();
            if (maybeNullRequestId == null || !lockHolder.getRequestId().equals(maybeNullRequestId)) {
                return new TryAcquireLockState(ReentrantLockState.HELD_NOT_OWNER);
            }
            lockHolder.increment();
            return new TryAcquireLockState(ReentrantLockState.HELD_OWNER, lockHolder.getOriginalLock());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createLock(String lockName, GlobalLock originalLock) {
        String requestId = this.getRequestId();
        if (requestId == null) {
            return;
        }
        Map<String, LockHolder> map = this.lockTable;
        synchronized (map) {
            LockHolder lockHolder = this.lockTable.get(lockName);
            if (lockHolder != null) {
                throw new IllegalStateException(String.format("ReentrantLock createLock %s : lock already current request = %s, owner request = %s", lockName, requestId, lockHolder.getRequestId()));
            }
            if (lockHolder == null) {
                lockHolder = new LockHolder(requestId, originalLock);
                this.lockTable.put(lockName, lockHolder);
            }
            lockHolder.increment();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean releaseLock(String lockName) {
        String requestId = this.getRequestId();
        if (requestId == null) {
            return true;
        }
        Map<String, LockHolder> map = this.lockTable;
        synchronized (map) {
            LockHolder lockHolder = this.lockTable.get(lockName);
            if (lockHolder == null) {
                throw new IllegalStateException(String.format("ReentrantLock releaseLock %s : cannot find lock in the table, current request = %s", lockName, requestId));
            }
            if (!lockHolder.getRequestId().equals(requestId)) {
                throw new IllegalStateException(String.format("ReentrantLock releaseLock %s : current request = %s, owner request = %s", lockName, requestId, lockHolder.getRequestId()));
            }
            boolean free = lockHolder.decrement();
            if (free) {
                this.lockTable.remove(lockName);
            }
            return free;
        }
    }

    private String getRequestId() {
        RequestData requestData = Request.getPerThreadRequestData();
        return requestData != null ? requestData.getRequestId() : null;
    }

    private static class LockHolder {
        private final String requestId;
        private final GlobalLock originalLock;
        private int refCount;

        public LockHolder(String requestId, GlobalLock originalLock) {
            this.requestId = requestId;
            this.originalLock = originalLock;
            this.refCount = 0;
        }

        public void increment() {
            ++this.refCount;
        }

        public boolean decrement() {
            return --this.refCount == 0;
        }

        public String getRequestId() {
            return this.requestId;
        }

        public GlobalLock getOriginalLock() {
            return this.originalLock;
        }
    }

    public static class TryAcquireLockState {
        private final ReentrantLockState lockState;
        private final GlobalLock originalLock;

        public TryAcquireLockState(ReentrantLockState lockState) {
            this(lockState, null);
        }

        public TryAcquireLockState(ReentrantLockState lockState, GlobalLock originalLock) {
            this.lockState = lockState;
            this.originalLock = originalLock;
        }

        public ReentrantLockState getLockState() {
            return this.lockState;
        }

        public GlobalLock getOriginalLock() {
            return this.originalLock;
        }
    }

    public static enum ReentrantLockState {
        FREE,
        HELD_OWNER,
        HELD_NOT_OWNER;

    }
}

