/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker.postgresql;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.TimeUnit;
import org.killbill.commons.locker.GlobalLockDao;

public class PostgreSQLGlobalLockDao
implements GlobalLockDao {
    @Override
    public boolean lock(Connection connection, String lockName, long timeout, TimeUnit timeUnit) throws SQLException {
        String sql = String.format("SELECT pg_try_advisory_lock(%s);", lockName);
        return this.executeLockQuery(connection, sql);
    }

    @Override
    public boolean releaseLock(Connection connection, String lockName) throws SQLException {
        String sql = String.format("SELECT pg_advisory_unlock(%s);", lockName);
        return this.executeLockQuery(connection, sql);
    }

    @Override
    public boolean isLockFree(Connection connection, String lockName) throws SQLException {
        String sql = String.format("SELECT CASE WHEN pg_try_advisory_lock(%s) THEN pg_advisory_unlock(%s) ELSE FALSE END;", lockName, lockName);
        return this.executeLockQuery(connection, sql);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean executeLockQuery(Connection connection, String query) throws SQLException {
        try (Statement statement = null;){
            statement = connection.createStatement();
            ResultSet rs = statement.executeQuery(query);
            boolean bl = rs.next() && rs.getBoolean(1);
            return bl;
        }
    }
}

