/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker;

import java.util.concurrent.TimeUnit;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.locker.GlobalLocker;
import org.killbill.commons.locker.LockFailedException;
import org.killbill.commons.locker.ReentrantLock;
import org.killbill.commons.profiling.Profiling;
import org.killbill.commons.profiling.ProfilingFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlobalLockerBase
implements GlobalLocker {
    protected static final long DEFAULT_TIMEOUT_MILLIS = 100L;
    protected static final Logger logger = LoggerFactory.getLogger(GlobalLockerBase.class);
    protected final long timeout;
    protected final TimeUnit timeUnit;
    protected final ReentrantLock lockTable;
    private final Profiling<GlobalLock, LockFailedException> prof;

    public GlobalLockerBase(long timeout, TimeUnit timeUnit) {
        this.timeout = timeout;
        this.timeUnit = timeUnit;
        this.lockTable = new ReentrantLock();
        this.prof = new Profiling();
    }

    @Override
    public GlobalLock lockWithNumberOfTries(final String service, final String lockKey, final int retry) throws LockFailedException {
        return (GlobalLock)this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.GLOCK, "lock", (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<GlobalLock, LockFailedException>(){

            public GlobalLock execute() throws LockFailedException {
                String lockName = GlobalLockerBase.this.getLockName(service, lockKey);
                int tries_left = retry;
                while (tries_left-- > 0) {
                    GlobalLock lock = GlobalLockerBase.this.lock(lockName);
                    if (lock != null) {
                        return lock;
                    }
                    if (tries_left <= 0) continue;
                    GlobalLockerBase.this.sleep();
                }
                logger.warn(String.format("Failed to acquire lock %s for service %s after %s retries", lockKey, service, retry));
                throw new LockFailedException();
            }
        });
    }

    protected GlobalLock lock(String lockName) {
        ReentrantLock.TryAcquireLockState lockState = this.lockTable.tryAcquireLockForExistingOwner(lockName);
        if (lockState.getLockState() == ReentrantLock.ReentrantLockState.HELD_OWNER) {
            return lockState.getOriginalLock();
        }
        if (lockState.getLockState() == ReentrantLock.ReentrantLockState.HELD_NOT_OWNER) {
            try {
                Thread.sleep(TimeUnit.MILLISECONDS.convert(this.timeout, this.timeUnit));
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("lock got interrupted", (Throwable)e);
            }
            return null;
        }
        return this.doLock(lockName);
    }

    protected abstract GlobalLock doLock(String var1);

    protected abstract String getLockName(String var1, String var2);

    private void sleep() {
        try {
            Thread.sleep(TimeUnit.MILLISECONDS.convert(this.timeout, this.timeUnit));
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            logger.warn("GlobalLockerBase got interrupted", (Throwable)e);
        }
    }
}

