/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.Connection;
import java.sql.SQLException;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.locker.GlobalLockDao;
import org.killbill.commons.locker.ResetReentrantLockCallback;
import org.killbill.commons.profiling.Profiling;
import org.killbill.commons.profiling.ProfilingFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalLockBase
implements GlobalLock {
    private static final Logger logger = LoggerFactory.getLogger(GlobalLockBase.class);
    private final GlobalLockDao lockDao;
    private final Connection connection;
    private final String lockName;
    private final ResetReentrantLockCallback resetCallback;
    private final Profiling<Void, RuntimeException> prof;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public GlobalLockBase(Connection connection, String lockName, GlobalLockDao lockDao, ResetReentrantLockCallback resetCallback) {
        this.lockDao = lockDao;
        this.connection = connection;
        this.lockName = lockName;
        this.resetCallback = resetCallback;
        this.prof = new Profiling();
    }

    @Override
    public void release() {
        this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.GLOCK, "release", (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Void, RuntimeException>(){

            public Void execute() throws RuntimeException {
                if (GlobalLockBase.this.resetCallback != null && !GlobalLockBase.this.resetCallback.reset(GlobalLockBase.this.lockName)) {
                    return null;
                }
                try {
                    GlobalLockBase.this.lockDao.releaseLock(GlobalLockBase.this.connection, GlobalLockBase.this.lockName);
                }
                catch (SQLException e) {
                    logger.warn("Unable to release lock for " + GlobalLockBase.this.lockName, (Throwable)e);
                }
                finally {
                    try {
                        GlobalLockBase.this.connection.close();
                    }
                    catch (SQLException e) {
                        logger.warn("Unable to close connection", (Throwable)e);
                    }
                }
                return null;
            }
        });
    }
}

