/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.locker.GlobalLockDao;
import org.killbill.commons.locker.GlobalLockerBase;
import org.killbill.commons.locker.ResetReentrantLockCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class GlobalLockerBaseWithDao
extends GlobalLockerBase {
    private static final Logger logger = LoggerFactory.getLogger(GlobalLockerBaseWithDao.class);
    protected final GlobalLockDao globalLockDao;
    private final DataSource dataSource;

    public GlobalLockerBaseWithDao(DataSource dataSource, GlobalLockDao globalLockDao, long timeout, TimeUnit timeUnit) {
        super(timeout, timeUnit);
        this.dataSource = dataSource;
        this.globalLockDao = globalLockDao;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFree(String service, String lockKey) {
        String lockName = this.getLockName(service, lockKey);
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            boolean bl = this.globalLockDao.isLockFree(connection, lockName);
            return bl;
        }
        catch (SQLException e) {
            logger.warn("Unable to check if lock is free", (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn("Unable to close connection", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected GlobalLock doLock(String lockName) {
        Connection connection = null;
        boolean obtained = false;
        try {
            connection = this.dataSource.getConnection();
            obtained = this.globalLockDao.lock(connection, lockName, this.timeout, this.timeUnit);
            if (obtained) {
                GlobalLock lock = this.getGlobalLock(connection, lockName, new ResetReentrantLockCallback(){

                    @Override
                    public boolean reset(String lockName) {
                        return GlobalLockerBaseWithDao.this.lockTable.releaseLock(lockName);
                    }
                });
                this.lockTable.createLock(lockName, lock);
                GlobalLock globalLock = lock;
                return globalLock;
            }
        }
        catch (SQLException e) {
            logger.warn("Unable to obtain lock for {}", (Object)lockName, (Object)e);
        }
        finally {
            if (!obtained && connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    logger.warn("Unable to close connection", (Throwable)e);
                }
            }
        }
        return null;
    }

    protected abstract GlobalLock getGlobalLock(Connection var1, String var2, ResetReentrantLockCallback var3);
}

