/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker.postgresql;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.util.concurrent.TimeUnit;
import javax.sql.DataSource;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.locker.GlobalLocker;
import org.killbill.commons.locker.GlobalLockerBaseWithDao;
import org.killbill.commons.locker.ResetReentrantLockCallback;
import org.killbill.commons.locker.postgresql.PostgreSQLGlobalLock;
import org.killbill.commons.locker.postgresql.PostgreSQLGlobalLockDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSQLGlobalLocker
extends GlobalLockerBaseWithDao
implements GlobalLocker {
    private static final Logger logger = LoggerFactory.getLogger(PostgreSQLGlobalLocker.class);

    public PostgreSQLGlobalLocker(DataSource dataSource) {
        this(dataSource, 100L, TimeUnit.MILLISECONDS);
    }

    public PostgreSQLGlobalLocker(DataSource dataSource, long timeout, TimeUnit timeUnit) {
        super(dataSource, new PostgreSQLGlobalLockDao(), timeout, timeUnit);
    }

    @Override
    protected GlobalLock getGlobalLock(Connection connection, String lockName, ResetReentrantLockCallback resetCb) {
        return new PostgreSQLGlobalLock(connection, lockName, this.globalLockDao, resetCb);
    }

    @Override
    protected String getLockName(String service, String lockKey) {
        String lockName = service + "-" + lockKey;
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            byte[] bytes = messageDigest.digest(lockName.getBytes(StandardCharsets.UTF_8));
            return String.valueOf(ByteBuffer.wrap(bytes).getLong());
        }
        catch (NoSuchAlgorithmException e) {
            logger.warn("Unable to allocate MessageDigest", (Throwable)e);
            return String.valueOf(lockName.hashCode());
        }
    }
}

