/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker.memory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.locker.GlobalLocker;
import org.killbill.commons.locker.GlobalLockerBase;

public class MemoryGlobalLocker
extends GlobalLockerBase
implements GlobalLocker {
    private final Map<String, AtomicBoolean> locks = new ConcurrentHashMap<String, AtomicBoolean>();

    public MemoryGlobalLocker() {
        super(100L, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized boolean isFree(String service, String lockKey) {
        String lockName = this.getLockName(service, lockKey);
        return this.isFree(lockName);
    }

    private synchronized Boolean isFree(String lockName) {
        AtomicBoolean lock = this.locks.get(lockName);
        return lock == null || !lock.get();
    }

    @Override
    protected synchronized GlobalLock doLock(final String lockName) {
        if (!this.isFree(lockName).booleanValue()) {
            return null;
        }
        if (this.locks.get(lockName) == null) {
            this.locks.put(lockName, new AtomicBoolean(true));
        } else {
            this.locks.get(lockName).set(true);
        }
        GlobalLock lock = new GlobalLock(){

            @Override
            public void release() {
                if (MemoryGlobalLocker.this.lockTable.releaseLock(lockName)) {
                    MemoryGlobalLocker.this.locks.get(lockName).set(false);
                }
            }
        };
        this.lockTable.createLock(lockName, lock);
        return lock;
    }

    @Override
    protected String getLockName(String service, String lockKey) {
        return service + "-" + lockKey;
    }
}

