/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.locker.memory;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.killbill.commons.locker.GlobalLock;
import org.killbill.commons.locker.GlobalLocker;
import org.killbill.commons.locker.LockFailedException;

public class MemoryGlobalLocker
implements GlobalLocker {
    private final Map<String, AtomicBoolean> locks = new ConcurrentHashMap<String, AtomicBoolean>();

    public GlobalLock lockWithNumberOfTries(String service, String lockKey, int retry) throws LockFailedException {
        String lockName = this.getLockName(service, lockKey);
        int tries_left = retry;
        while (tries_left-- > 0) {
            GlobalLock lock = this.lock(lockName);
            if (lock == null) continue;
            return lock;
        }
        throw new LockFailedException();
    }

    public synchronized boolean isFree(String service, String lockKey) {
        String lockName = this.getLockName(service, lockKey);
        return this.isFree(lockName);
    }

    private synchronized Boolean isFree(String lockName) {
        AtomicBoolean lock = this.locks.get(lockName);
        return lock == null || !lock.get();
    }

    private synchronized GlobalLock lock(final String lockName) throws LockFailedException {
        if (!this.isFree(lockName).booleanValue()) {
            return null;
        }
        if (this.locks.get(lockName) == null) {
            this.locks.put(lockName, new AtomicBoolean(true));
        } else {
            this.locks.get(lockName).set(true);
        }
        return new GlobalLock(){

            public void release() {
                ((AtomicBoolean)MemoryGlobalLocker.this.locks.get(lockName)).set(false);
            }
        };
    }

    private String getLockName(String service, String lockKey) {
        return service + "-" + lockKey;
    }
}

