/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.impl;

import java.util.HashMap;
import java.util.Map;
import org.killbill.commons.metrics.api.Counter;
import org.killbill.commons.metrics.api.Gauge;
import org.killbill.commons.metrics.api.Histogram;
import org.killbill.commons.metrics.api.Meter;
import org.killbill.commons.metrics.api.Metric;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.Timer;
import org.killbill.commons.metrics.impl.NoOpCounter;
import org.killbill.commons.metrics.impl.NoOpHistogram;
import org.killbill.commons.metrics.impl.NoOpMeter;
import org.killbill.commons.metrics.impl.NoOpTimer;

public class NoOpMetricRegistry
implements MetricRegistry {
    private final Map<String, Counter> counters = new HashMap<String, Counter>();
    private final Map<String, Gauge<?>> gauges = new HashMap();
    private final Map<String, Meter> meters = new HashMap<String, Meter>();
    private final Map<String, Histogram> histograms = new HashMap<String, Histogram>();
    private final Map<String, Timer> timers = new HashMap<String, Timer>();

    @Override
    public Counter counter(String name) {
        NoOpCounter counter = new NoOpCounter();
        this.counters.put(name, counter);
        return counter;
    }

    @Override
    public <T> Gauge<T> gauge(String name, Gauge<T> gauge) {
        this.gauges.put(name, gauge);
        return gauge;
    }

    @Override
    public Meter meter(String name) {
        NoOpMeter meter = new NoOpMeter();
        this.meters.put(name, meter);
        return meter;
    }

    @Override
    public Histogram histogram(String name) {
        NoOpHistogram histogram = new NoOpHistogram();
        this.histograms.put(name, histogram);
        return histogram;
    }

    @Override
    public Timer timer(String name) {
        NoOpTimer timer = new NoOpTimer();
        this.timers.put(name, timer);
        return timer;
    }

    @Override
    public boolean remove(String name) {
        if (this.gauges.remove(name) != null) {
            return true;
        }
        if (this.counters.remove(name) != null) {
            return true;
        }
        if (this.histograms.remove(name) != null) {
            return true;
        }
        if (this.meters.remove(name) != null) {
            return true;
        }
        return this.timers.remove(name) != null;
    }

    @Override
    public Map<String, ?> getMetrics() {
        HashMap<String, Metric> metrics = new HashMap<String, Metric>();
        metrics.putAll(this.gauges);
        metrics.putAll(this.counters);
        metrics.putAll(this.histograms);
        metrics.putAll(this.meters);
        metrics.putAll(this.timers);
        return metrics;
    }

    @Override
    public Map<String, Gauge<?>> getGauges() {
        return new HashMap(this.gauges);
    }

    @Override
    public Map<String, Counter> getCounters() {
        return new HashMap<String, Counter>(this.counters);
    }

    @Override
    public Map<String, Histogram> getHistograms() {
        return new HashMap<String, Histogram>(this.histograms);
    }

    @Override
    public Map<String, Meter> getMeters() {
        return new HashMap<String, Meter>(this.meters);
    }

    @Override
    public Map<String, Timer> getTimers() {
        return new HashMap<String, Timer>(this.timers);
    }
}

