/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.guice;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.killbill.commons.metrics.api.Counter;
import org.killbill.commons.metrics.api.annotation.Counted;

class CountedInterceptor
implements MethodInterceptor {
    private final Counter counter;
    private final boolean decrementAfterMethod;

    CountedInterceptor(Counter counter, Counted annotation) {
        this.counter = counter;
        this.decrementAfterMethod = !annotation.monotonic();
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        this.counter.inc(1L);
        try {
            Object object = invocation.proceed();
            return object;
        }
        finally {
            if (this.decrementAfterMethod) {
                this.counter.dec(1L);
            }
        }
    }
}

