/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.guice;

import com.google.inject.TypeLiteral;
import com.google.inject.spi.TypeEncounter;
import com.google.inject.spi.TypeListener;
import java.lang.reflect.Method;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.annotation.Gauge;
import org.killbill.commons.metrics.guice.GaugeInjectionListener;
import org.killbill.commons.metrics.guice.MetricNamer;
import org.killbill.commons.metrics.guice.annotation.AnnotationResolver;

public class GaugeListener
implements TypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;

    public GaugeListener(MetricRegistry metricRegistry, MetricNamer metricNamer, AnnotationResolver annotationResolver) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
        this.annotationResolver = annotationResolver;
    }

    public <I> void hear(TypeLiteral<I> literal, TypeEncounter<I> encounter) {
        Class klass;
        Class instanceType = klass = literal.getRawType();
        do {
            for (Method method : klass.getDeclaredMethods()) {
                Gauge annotation;
                if (method.isSynthetic() || (annotation = this.annotationResolver.findAnnotation(Gauge.class, method)) == null) continue;
                if (method.getParameterTypes().length == 0) {
                    String metricName = this.metricNamer.getNameForGauge(instanceType, method, annotation);
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    encounter.register(new GaugeInjectionListener(this.metricRegistry, metricName, method));
                    continue;
                }
                encounter.addError("Method %s is annotated with @Gauge but requires parameters.", new Object[]{method});
            }
        } while ((klass = klass.getSuperclass()) != null);
    }
}

