/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.guice;

import com.google.inject.AbstractModule;
import com.google.inject.TypeLiteral;
import com.google.inject.matcher.Matcher;
import com.google.inject.matcher.Matchers;
import javax.annotation.Nonnull;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.guice.CountedListener;
import org.killbill.commons.metrics.guice.ExceptionMeteredListener;
import org.killbill.commons.metrics.guice.GaugeInstanceClassMetricNamer;
import org.killbill.commons.metrics.guice.GaugeListener;
import org.killbill.commons.metrics.guice.MeteredListener;
import org.killbill.commons.metrics.guice.MetricNamer;
import org.killbill.commons.metrics.guice.TimedListener;
import org.killbill.commons.metrics.guice.annotation.AnnotationResolver;
import org.killbill.commons.metrics.guice.annotation.MethodAnnotationResolver;
import org.killbill.commons.utils.Preconditions;

public class MetricsInstrumentationModule
extends AbstractModule {
    private final MetricRegistry metricRegistry;
    private final Matcher<? super TypeLiteral<?>> matcher;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;

    private MetricsInstrumentationModule(MetricRegistry metricRegistry, Matcher<? super TypeLiteral<?>> matcher, MetricNamer metricNamer, AnnotationResolver annotationResolver) {
        this.metricRegistry = metricRegistry;
        this.matcher = matcher;
        this.metricNamer = metricNamer;
        this.annotationResolver = annotationResolver;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected void configure() {
        this.bindListener(this.matcher, new MeteredListener(this.metricRegistry, this.metricNamer, this.annotationResolver));
        this.bindListener(this.matcher, new TimedListener(this.metricRegistry, this.metricNamer, this.annotationResolver));
        this.bindListener(this.matcher, new GaugeListener(this.metricRegistry, this.metricNamer, this.annotationResolver));
        this.bindListener(this.matcher, new ExceptionMeteredListener(this.metricRegistry, this.metricNamer, this.annotationResolver));
        this.bindListener(this.matcher, new CountedListener(this.metricRegistry, this.metricNamer, this.annotationResolver));
    }

    public static class Builder {
        private MetricRegistry metricRegistry;
        private Matcher<? super TypeLiteral<?>> matcher = Matchers.any();
        private MetricNamer metricNamer = new GaugeInstanceClassMetricNamer();
        private AnnotationResolver annotationResolver = new MethodAnnotationResolver();

        @Nonnull
        public Builder withMetricRegistry(@Nonnull MetricRegistry metricRegistry) {
            this.metricRegistry = metricRegistry;
            return this;
        }

        @Nonnull
        public Builder withMatcher(@Nonnull Matcher<? super TypeLiteral<?>> matcher) {
            this.matcher = matcher;
            return this;
        }

        @Nonnull
        public Builder withMetricNamer(@Nonnull MetricNamer metricNamer) {
            this.metricNamer = metricNamer;
            return this;
        }

        @Nonnull
        public Builder withAnnotationMatcher(@Nonnull AnnotationResolver annotationResolver) {
            this.annotationResolver = annotationResolver;
            return this;
        }

        @Nonnull
        public MetricsInstrumentationModule build() {
            return new MetricsInstrumentationModule((MetricRegistry)Preconditions.checkNotNull((Object)this.metricRegistry), (Matcher)Preconditions.checkNotNull(this.matcher), (MetricNamer)Preconditions.checkNotNull((Object)this.metricNamer), (AnnotationResolver)Preconditions.checkNotNull((Object)this.annotationResolver));
        }
    }
}

