/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.guice;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;
import org.killbill.commons.metrics.api.Counter;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.annotation.Counted;
import org.killbill.commons.metrics.guice.CountedInterceptor;
import org.killbill.commons.metrics.guice.DeclaredMethodsTypeListener;
import org.killbill.commons.metrics.guice.MetricNamer;
import org.killbill.commons.metrics.guice.annotation.AnnotationResolver;

public class CountedListener
extends DeclaredMethodsTypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;

    public CountedListener(MetricRegistry metricRegistry, MetricNamer metricNamer, AnnotationResolver annotationResolver) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
        this.annotationResolver = annotationResolver;
    }

    @Override
    @Nullable
    protected MethodInterceptor getInterceptor(Method method) {
        Counted annotation = this.annotationResolver.findAnnotation(Counted.class, method);
        if (annotation != null) {
            Counter counter = this.metricRegistry.counter(this.metricNamer.getNameForCounted(method, annotation));
            return new CountedInterceptor(counter, annotation);
        }
        return null;
    }
}

