/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.guice;

import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.killbill.commons.metrics.api.Meter;

class ExceptionMeteredInterceptor
implements MethodInterceptor {
    private final Meter meter;
    private final Class<? extends Throwable> klass;

    ExceptionMeteredInterceptor(Meter meter, Class<? extends Throwable> klass) {
        this.meter = meter;
        this.klass = klass;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        try {
            return invocation.proceed();
        }
        catch (Throwable t) {
            if (this.klass.isAssignableFrom(t.getClass())) {
                this.meter.mark(1L);
            }
            throw t;
        }
    }
}

