/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.guice;

import com.google.inject.spi.InjectionListener;
import java.lang.reflect.Method;
import org.killbill.commons.metrics.api.Gauge;
import org.killbill.commons.metrics.api.MetricRegistry;

public class GaugeInjectionListener<I>
implements InjectionListener<I> {
    private final MetricRegistry metricRegistry;
    private final String metricName;
    private final Method method;

    public GaugeInjectionListener(MetricRegistry metricRegistry, String metricName, Method method) {
        this.metricRegistry = metricRegistry;
        this.metricName = metricName;
        this.method = method;
    }

    public void afterInjection(final I i) {
        this.metricRegistry.gauge(this.metricName, (Gauge)new Gauge<Object>(){

            public Object getValue() {
                try {
                    return GaugeInjectionListener.this.method.invoke(i, new Object[0]);
                }
                catch (Exception e) {
                    return new RuntimeException(e);
                }
            }
        });
    }
}

