/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.health;

import java.util.Collections;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Inject;
import org.killbill.commons.health.api.HealthCheck;
import org.killbill.commons.health.api.HealthCheckRegistry;
import org.killbill.commons.health.api.Result;
import org.killbill.commons.health.impl.UnhealthyResultBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KillBillHealthCheckRegistry
implements HealthCheckRegistry {
    private static final Logger logger = LoggerFactory.getLogger(KillBillHealthCheckRegistry.class);
    private final ConcurrentMap<String, HealthCheck> healthChecks = new ConcurrentHashMap<String, HealthCheck>();

    @Inject
    public void initialize(Set<HealthCheck> healthChecks) {
        for (HealthCheck healthCheck : healthChecks) {
            this.register(healthCheck.getClass().getName(), healthCheck);
        }
    }

    public Set<String> getNames() {
        return Collections.unmodifiableSortedSet(new TreeSet(this.healthChecks.keySet()));
    }

    public Result runHealthCheck(String name) throws NoSuchElementException {
        HealthCheck healthCheck = (HealthCheck)this.healthChecks.get(name);
        if (healthCheck == null) {
            throw new NoSuchElementException("No health check named " + name + " exists");
        }
        Result result = this.execute(healthCheck);
        this.logUnHealthyResult(name, result);
        return result;
    }

    public Result execute(HealthCheck healthCheck) {
        try {
            return healthCheck.check();
        }
        catch (Exception e) {
            return new UnhealthyResultBuilder().setError((Throwable)e).createUnhealthyResult();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(String name, HealthCheck healthCheck) {
        KillBillHealthCheckRegistry killBillHealthCheckRegistry = this;
        synchronized (killBillHealthCheckRegistry) {
            if (this.healthChecks.containsKey(name)) {
                throw new IllegalArgumentException("A health check named " + name + " already exists");
            }
            this.healthChecks.put(name, healthCheck);
        }
    }

    private void logUnHealthyResult(String healthCheckName, Result healthCheckResult) {
        if (!healthCheckResult.isHealthy()) {
            logger.warn("HealthCheck {} failed: {}", (Object)healthCheckName, (Object)healthCheckResult.toString());
        }
    }
}

