/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.servlets;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import org.killbill.commons.metrics.api.Counter;
import org.killbill.commons.metrics.api.Meter;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.Timer;
import org.killbill.commons.metrics.impl.NoOpMetricRegistry;

public class InstrumentedFilter
implements Filter {
    public static final String REGISTRY_ATTRIBUTE = InstrumentedFilter.class.getName() + ".registry";
    private static final String METRIC_PREFIX = "name-prefix";
    private static final String NAME_PREFIX = "responseCodes.";
    private static final int OK = 200;
    private static final int CREATED = 201;
    private static final int NO_CONTENT = 204;
    private static final int BAD_REQUEST = 400;
    private static final int NOT_FOUND = 404;
    private static final int SERVER_ERROR = 500;
    private final Map<Integer, String> meterNamesByStatusCode = new HashMap<Integer, String>(6);
    private ConcurrentMap<Integer, Meter> metersByStatusCode;
    private Meter otherMeter;
    private Meter timeoutsMeter;
    private Meter errorsMeter;
    private Counter activeRequests;
    private Timer requestTimer;

    public InstrumentedFilter() {
        this.meterNamesByStatusCode.put(200, "responseCodes.ok");
        this.meterNamesByStatusCode.put(201, "responseCodes.created");
        this.meterNamesByStatusCode.put(204, "responseCodes.noContent");
        this.meterNamesByStatusCode.put(400, "responseCodes.badRequest");
        this.meterNamesByStatusCode.put(404, "responseCodes.notFound");
        this.meterNamesByStatusCode.put(500, "responseCodes.serverError");
    }

    public void init(FilterConfig filterConfig) {
        MetricRegistry metricsRegistry = this.getMetricsFactory(filterConfig);
        String metricName = filterConfig.getInitParameter(METRIC_PREFIX);
        if (metricName == null || metricName.isEmpty()) {
            metricName = this.getClass().getName();
        }
        this.metersByStatusCode = new ConcurrentHashMap<Integer, Meter>(this.meterNamesByStatusCode.size());
        for (Map.Entry<Integer, String> entry : this.meterNamesByStatusCode.entrySet()) {
            this.metersByStatusCode.put(entry.getKey(), metricsRegistry.meter(String.format("%s.%s", metricName, entry.getValue())));
        }
        this.otherMeter = metricsRegistry.meter(String.format("%s.%s", metricName, "responseCodes.other"));
        this.timeoutsMeter = metricsRegistry.meter(String.format("%s.%s", metricName, "timeouts"));
        this.errorsMeter = metricsRegistry.meter(String.format("%s.%s", metricName, "errors"));
        this.activeRequests = metricsRegistry.counter(String.format("%s.%s", metricName, "activeRequests"));
        this.requestTimer = metricsRegistry.timer(String.format("%s.%s", metricName, "requests"));
    }

    private MetricRegistry getMetricsFactory(FilterConfig filterConfig) {
        Object o = filterConfig.getServletContext().getAttribute(REGISTRY_ATTRIBUTE);
        Object metricsRegistry = o instanceof MetricRegistry ? (MetricRegistry)o : new NoOpMetricRegistry();
        return metricsRegistry;
    }

    public void destroy() {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        StatusExposingServletResponse wrappedResponse = new StatusExposingServletResponse((HttpServletResponse)response);
        this.activeRequests.inc(1L);
        long start = System.nanoTime();
        boolean error = false;
        try {
            chain.doFilter(request, (ServletResponse)wrappedResponse);
        }
        catch (IOException | RuntimeException | ServletException e) {
            error = true;
            throw e;
        }
        finally {
            if (!error && request.isAsyncStarted()) {
                request.getAsyncContext().addListener((AsyncListener)new AsyncResultListener(this.requestTimer, start));
            } else {
                this.requestTimer.update(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                this.activeRequests.dec(1L);
                if (error) {
                    this.errorsMeter.mark(1L);
                } else {
                    this.markMeterForStatusCode(wrappedResponse.getStatus());
                }
            }
        }
    }

    private void markMeterForStatusCode(int status) {
        Meter metric = (Meter)this.metersByStatusCode.get(status);
        if (metric != null) {
            metric.mark(1L);
        } else {
            this.otherMeter.mark(1L);
        }
    }

    private class AsyncResultListener
    implements AsyncListener {
        private final Timer timer;
        private final long start;
        private boolean done = false;

        public AsyncResultListener(Timer timer, long start) {
            this.timer = timer;
            this.start = start;
        }

        public void onComplete(AsyncEvent event) {
            if (!this.done) {
                HttpServletResponse suppliedResponse = (HttpServletResponse)event.getSuppliedResponse();
                this.timer.update(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
                InstrumentedFilter.this.activeRequests.dec(1L);
                InstrumentedFilter.this.markMeterForStatusCode(suppliedResponse.getStatus());
            }
        }

        public void onTimeout(AsyncEvent event) {
            this.timer.update(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
            InstrumentedFilter.this.activeRequests.dec(1L);
            InstrumentedFilter.this.timeoutsMeter.mark(1L);
            this.done = true;
        }

        public void onError(AsyncEvent event) {
            this.timer.update(System.nanoTime() - this.start, TimeUnit.NANOSECONDS);
            InstrumentedFilter.this.activeRequests.dec(1L);
            InstrumentedFilter.this.errorsMeter.mark(1L);
            this.done = true;
        }

        public void onStartAsync(AsyncEvent event) {
        }
    }

    private static class StatusExposingServletResponse
    extends HttpServletResponseWrapper {
        private int httpStatus = 200;

        public StatusExposingServletResponse(HttpServletResponse response) {
            super(response);
        }

        public void sendError(int sc) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc);
        }

        public void sendError(int sc, String msg) throws IOException {
            this.httpStatus = sc;
            super.sendError(sc, msg);
        }

        public void setStatus(int sc, String sm) {
            this.httpStatus = sc;
            super.setStatus(sc, sm);
        }

        public int getStatus() {
            return this.httpStatus;
        }

        public void setStatus(int sc) {
            this.httpStatus = sc;
            super.setStatus(sc);
        }
    }
}

