/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.servlets;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.nio.charset.StandardCharsets;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ThreadDumpServlet
extends HttpServlet {
    private static final long serialVersionUID = -5131980901584483867L;
    private static final String CONTENT_TYPE = "text/plain";
    private transient ThreadDump threadDump;

    private static Boolean getParam(String initParam, boolean defaultValue) {
        return initParam == null ? defaultValue : Boolean.parseBoolean(initParam);
    }

    public void init() {
        try {
            this.threadDump = new ThreadDump(ManagementFactory.getThreadMXBean());
        }
        catch (NoClassDefFoundError ncdfe) {
            this.threadDump = null;
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        boolean includeMonitors = ThreadDumpServlet.getParam(req.getParameter("monitors"), true);
        boolean includeSynchronizers = ThreadDumpServlet.getParam(req.getParameter("synchronizers"), true);
        resp.setStatus(200);
        resp.setContentType(CONTENT_TYPE);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        if (this.threadDump == null) {
            resp.getWriter().println("Sorry your runtime environment does not allow to dump threads.");
            return;
        }
        try (ServletOutputStream output = resp.getOutputStream();){
            this.threadDump.dump(includeMonitors, includeSynchronizers, (OutputStream)output);
        }
    }

    public static class ThreadDump {
        private final ThreadMXBean threadMXBean;

        public ThreadDump(ThreadMXBean threadMXBean) {
            this.threadMXBean = threadMXBean;
        }

        public void dump(OutputStream out) {
            this.dump(true, true, out);
        }

        public void dump(boolean lockedMonitors, boolean lockedSynchronizers, OutputStream out) {
            ThreadInfo[] threads = this.threadMXBean.dumpAllThreads(lockedMonitors, lockedSynchronizers);
            PrintWriter writer = new PrintWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
            for (int ti = threads.length - 1; ti >= 0; --ti) {
                int j;
                ThreadInfo t = threads[ti];
                writer.printf("\"%s\" id=%d state=%s", new Object[]{t.getThreadName(), t.getThreadId(), t.getThreadState()});
                LockInfo lock = t.getLockInfo();
                if (lock != null && t.getThreadState() != Thread.State.BLOCKED) {
                    writer.printf("%n    - waiting on <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
                    writer.printf("%n    - locked <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
                } else if (lock != null && t.getThreadState() == Thread.State.BLOCKED) {
                    writer.printf("%n    - waiting to lock <0x%08x> (a %s)", lock.getIdentityHashCode(), lock.getClassName());
                }
                if (t.isSuspended()) {
                    writer.print(" (suspended)");
                }
                if (t.isInNative()) {
                    writer.print(" (running in native)");
                }
                writer.println();
                if (t.getLockOwnerName() != null) {
                    writer.printf("     owned by %s id=%d%n", t.getLockOwnerName(), t.getLockOwnerId());
                }
                StackTraceElement[] elements = t.getStackTrace();
                MonitorInfo[] monitors = t.getLockedMonitors();
                for (int i = 0; i < elements.length; ++i) {
                    StackTraceElement element = elements[i];
                    writer.printf("    at %s%n", element);
                    for (j = 1; j < monitors.length; ++j) {
                        MonitorInfo monitor = monitors[j];
                        if (monitor.getLockedStackDepth() != i) continue;
                        writer.printf("      - locked %s%n", monitor);
                    }
                }
                writer.println();
                LockInfo[] locks = t.getLockedSynchronizers();
                if (locks.length <= 0) continue;
                writer.printf("    Locked synchronizers: count = %d%n", locks.length);
                LockInfo[] var17 = locks;
                j = locks.length;
                for (int var18 = 0; var18 < j; ++var18) {
                    LockInfo l = var17[var18];
                    writer.printf("      - %s%n", l);
                }
                writer.println();
            }
            writer.println();
            writer.flush();
        }
    }
}

