/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.guice;

import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.killbill.commons.metrics.api.annotation.Counted;
import org.killbill.commons.metrics.api.annotation.ExceptionMetered;
import org.killbill.commons.metrics.api.annotation.Gauge;
import org.killbill.commons.metrics.api.annotation.Metered;
import org.killbill.commons.metrics.api.annotation.Timed;
import org.killbill.commons.metrics.guice.MetricNamer;

public class DeclaringClassMetricNamer
implements MetricNamer {
    static final String COUNTER_SUFFIX = "counter";
    static final String COUNTER_SUFFIX_MONOTONIC = "current";
    static final String GAUGE_SUFFIX = "gauge";
    static final String METERED_SUFFIX = "meter";
    static final String TIMED_SUFFIX = "timer";

    @Override
    @Nonnull
    public String getNameForCounted(@Nonnull Method method, @Nonnull Counted counted) {
        if (counted.absolute()) {
            return counted.name();
        }
        if (counted.name().isEmpty()) {
            if (counted.monotonic()) {
                return String.format("%s.%s.%s", method.getDeclaringClass().getName(), method.getName(), COUNTER_SUFFIX_MONOTONIC);
            }
            return String.format("%s.%s.%s", method.getDeclaringClass().getName(), method.getName(), COUNTER_SUFFIX);
        }
        return String.format("%s.%s", method.getDeclaringClass().getName(), counted.name());
    }

    @Override
    @Nonnull
    public String getNameForExceptionMetered(@Nonnull Method method, @Nonnull ExceptionMetered exceptionMetered) {
        if (exceptionMetered.absolute()) {
            return exceptionMetered.name();
        }
        if (exceptionMetered.name().isEmpty()) {
            return String.format("%s.%s.%s", method.getDeclaringClass().getName(), method.getName(), "exceptions");
        }
        return String.format("%s.%s", method.getDeclaringClass().getName(), exceptionMetered.name());
    }

    @Override
    @Nonnull
    public String getNameForGauge(@Nonnull Class<?> instanceClass, @Nonnull Method method, @Nonnull Gauge gauge) {
        if (gauge.absolute()) {
            return gauge.name();
        }
        if (gauge.name().isEmpty()) {
            return String.format("%s.%s.%s", method.getDeclaringClass().getName(), method.getName(), GAUGE_SUFFIX);
        }
        return String.format("%s.%s", method.getDeclaringClass().getName(), gauge.name());
    }

    @Override
    @Nonnull
    public String getNameForMetered(@Nonnull Method method, @Nonnull Metered metered) {
        if (metered.absolute()) {
            return metered.name();
        }
        if (metered.name().isEmpty()) {
            return String.format("%s.%s.%s", method.getDeclaringClass().getName(), method.getName(), METERED_SUFFIX);
        }
        return String.format("%s.%s", method.getDeclaringClass().getName(), metered.name());
    }

    @Override
    @Nonnull
    public String getNameForTimed(@Nonnull Method method, @Nonnull Timed timed) {
        if (timed.absolute()) {
            return timed.name();
        }
        if (timed.name().isEmpty()) {
            return String.format("%s.%s.%s", method.getDeclaringClass().getName(), method.getName(), TIMED_SUFFIX);
        }
        return String.format("%s.%s", method.getDeclaringClass().getName(), timed.name());
    }
}

