/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.guice;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;
import org.killbill.commons.metrics.api.Meter;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.annotation.ExceptionMetered;
import org.killbill.commons.metrics.guice.DeclaredMethodsTypeListener;
import org.killbill.commons.metrics.guice.ExceptionMeteredInterceptor;
import org.killbill.commons.metrics.guice.MetricNamer;
import org.killbill.commons.metrics.guice.annotation.AnnotationResolver;

public class ExceptionMeteredListener
extends DeclaredMethodsTypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;

    public ExceptionMeteredListener(MetricRegistry metricRegistry, MetricNamer metricNamer, AnnotationResolver annotationResolver) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
        this.annotationResolver = annotationResolver;
    }

    @Override
    @Nullable
    protected MethodInterceptor getInterceptor(Method method) {
        ExceptionMetered annotation = this.annotationResolver.findAnnotation(ExceptionMetered.class, method);
        if (annotation != null) {
            Meter meter = this.metricRegistry.meter(this.metricNamer.getNameForExceptionMetered(method, annotation));
            return new ExceptionMeteredInterceptor(meter, annotation.cause());
        }
        return null;
    }
}

