/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.guice;

import java.lang.reflect.Method;
import javax.annotation.Nullable;
import org.aopalliance.intercept.MethodInterceptor;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.api.Timer;
import org.killbill.commons.metrics.api.annotation.Timed;
import org.killbill.commons.metrics.guice.DeclaredMethodsTypeListener;
import org.killbill.commons.metrics.guice.MetricNamer;
import org.killbill.commons.metrics.guice.TimedInterceptor;
import org.killbill.commons.metrics.guice.annotation.AnnotationResolver;

public class TimedListener
extends DeclaredMethodsTypeListener {
    private final MetricRegistry metricRegistry;
    private final MetricNamer metricNamer;
    private final AnnotationResolver annotationResolver;

    public TimedListener(MetricRegistry metricRegistry, MetricNamer metricNamer, AnnotationResolver annotationResolver) {
        this.metricRegistry = metricRegistry;
        this.metricNamer = metricNamer;
        this.annotationResolver = annotationResolver;
    }

    @Override
    @Nullable
    protected MethodInterceptor getInterceptor(Method method) {
        Timed annotation = this.annotationResolver.findAnnotation(Timed.class, method);
        if (annotation != null) {
            Timer timer = this.metricRegistry.timer(this.metricNamer.getNameForTimed(method, annotation));
            return new TimedInterceptor(timer);
        }
        return null;
    }
}

