/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.modules;

import com.google.inject.AbstractModule;
import com.google.inject.Binder;
import com.google.inject.Module;
import com.google.inject.multibindings.Multibinder;
import java.util.Collections;
import java.util.List;
import org.killbill.commons.health.api.HealthCheck;
import org.killbill.commons.health.api.HealthCheckRegistry;
import org.killbill.commons.metrics.health.KillBillHealthCheckRegistry;
import org.killbill.commons.metrics.modules.AdminServletModule;

public class StatsModule
extends AbstractModule {
    private final String healthCheckUri;
    private final String metricsUri;
    private final String threadsUri;
    private final Iterable<Class<? extends HealthCheck>> healthChecks;

    public StatsModule() {
        this(Collections.emptyList());
    }

    public StatsModule(Class<? extends HealthCheck> healthCheck) {
        this(List.of(healthCheck));
    }

    public StatsModule(Class<? extends HealthCheck> ... healthChecks) {
        this(List.of(healthChecks));
    }

    public StatsModule(Iterable<Class<? extends HealthCheck>> healthChecks) {
        this("/1.0/healthcheck", "/1.0/metrics", "/1.0/threads", healthChecks);
    }

    public StatsModule(String healthCheckUri, String metricsUri, String threadsUri, Iterable<Class<? extends HealthCheck>> healthChecks) {
        this.healthCheckUri = healthCheckUri;
        this.metricsUri = metricsUri;
        this.threadsUri = threadsUri;
        this.healthChecks = healthChecks;
    }

    protected void configure() {
        Multibinder healthChecksBinder = Multibinder.newSetBinder((Binder)this.binder(), HealthCheck.class);
        for (Class<? extends HealthCheck> healthCheckClass : this.healthChecks) {
            healthChecksBinder.addBinding().to(healthCheckClass).asEagerSingleton();
        }
        this.install((Module)new AdminServletModule(this.healthCheckUri, this.metricsUri, this.threadsUri));
        this.bind(HealthCheckRegistry.class).toInstance((Object)this.createHealthCheckRegistry());
    }

    protected HealthCheckRegistry createHealthCheckRegistry() {
        return new KillBillHealthCheckRegistry();
    }
}

