/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.servlets;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.killbill.commons.health.api.HealthCheckRegistry;
import org.killbill.commons.health.api.Result;
import org.killbill.commons.metrics.servlets.HealthCheckJacksonModule;

public class HealthCheckServlet
extends HttpServlet {
    public static final String HEALTH_CHECK_REGISTRY = HealthCheckServlet.class.getCanonicalName() + ".registry";
    public static final String HEALTH_CHECK_MAPPER = HealthCheckServlet.class.getCanonicalName() + ".mapper";
    private static final long serialVersionUID = -128753347944002146L;
    private static final String CONTENT_TYPE = "application/json";
    private transient HealthCheckRegistry registry;
    private transient ObjectMapper mapper;

    public HealthCheckServlet() {
    }

    public HealthCheckServlet(HealthCheckRegistry registry) {
        this.registry = registry;
    }

    private static boolean isAllHealthy(Map<String, Result> results) {
        for (Result result : results.values()) {
            if (result.isHealthy()) continue;
            return false;
        }
        return true;
    }

    public void init(ServletConfig config) throws ServletException {
        Object mapperAttr;
        super.init(config);
        ServletContext context = config.getServletContext();
        if (null == this.registry) {
            Object registryAttr = context.getAttribute(HEALTH_CHECK_REGISTRY);
            if (registryAttr instanceof HealthCheckRegistry) {
                this.registry = (HealthCheckRegistry)registryAttr;
            } else {
                throw new ServletException("Couldn't find a HealthCheckRegistry instance.");
            }
        }
        this.mapper = (mapperAttr = context.getAttribute(HEALTH_CHECK_MAPPER)) instanceof ObjectMapper ? (ObjectMapper)mapperAttr : new ObjectMapper();
        this.mapper.registerModule((Module)new HealthCheckJacksonModule());
    }

    public void destroy() {
        super.destroy();
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        SortedMap<String, Result> results = this.runHealthChecks();
        resp.setContentType(CONTENT_TYPE);
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        if (results.isEmpty()) {
            resp.setStatus(501);
        } else if (HealthCheckServlet.isAllHealthy(results)) {
            resp.setStatus(200);
        } else {
            resp.setStatus(500);
        }
        try (ServletOutputStream output = resp.getOutputStream();){
            this.getWriter((ServletRequest)req).writeValue((OutputStream)output, results);
        }
    }

    private ObjectWriter getWriter(ServletRequest request) {
        boolean prettyPrint = Boolean.parseBoolean(request.getParameter("pretty"));
        if (prettyPrint) {
            return this.mapper.writerWithDefaultPrettyPrinter();
        }
        return this.mapper.writer();
    }

    private SortedMap<String, Result> runHealthChecks() {
        TreeMap<String, Result> results = new TreeMap<String, Result>();
        for (String name : this.registry.getNames()) {
            results.put(name, this.registry.runHealthCheck(name));
        }
        return results;
    }
}

