/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.commons.metrics.servlets;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.killbill.commons.metrics.api.MetricRegistry;
import org.killbill.commons.metrics.impl.NoOpMetricRegistry;
import org.killbill.commons.metrics.servlets.MetricsJacksonModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricsServlet
extends HttpServlet {
    private static final Logger logger = LoggerFactory.getLogger(MetricsServlet.class);
    public static final String METRICS_REGISTRY = MetricsServlet.class.getCanonicalName() + ".registry";
    public static final String OBJECT_MAPPER = MetricsServlet.class.getCanonicalName() + ".mapper";
    private static final long serialVersionUID = 5368376475901310760L;
    private static final String CONTENT_TYPE = "application/json";
    protected String allowedOrigin;
    protected transient MetricRegistry registry;
    protected transient ObjectMapper mapper;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        ServletContext context = config.getServletContext();
        if (null == this.registry) {
            Object registryAttr = context.getAttribute(METRICS_REGISTRY);
            if (registryAttr instanceof MetricRegistry) {
                if (registryAttr instanceof NoOpMetricRegistry) {
                    logger.warn("Metrics are not enabled");
                } else {
                    this.registry = (MetricRegistry)registryAttr;
                }
            } else {
                throw new ServletException("Couldn't find a MetricRegistry instance.");
            }
        }
        if (null == this.mapper) {
            Object mapperAttr = context.getAttribute(OBJECT_MAPPER);
            this.mapper = mapperAttr instanceof ObjectMapper ? (ObjectMapper)mapperAttr : new ObjectMapper();
            this.mapper.registerModule((Module)new MetricsJacksonModule(TimeUnit.SECONDS, TimeUnit.SECONDS, false));
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        resp.setContentType(CONTENT_TYPE);
        if (this.allowedOrigin != null) {
            resp.setHeader("Access-Control-Allow-Origin", this.allowedOrigin);
        }
        resp.setHeader("Cache-Control", "must-revalidate,no-cache,no-store");
        resp.setStatus(200);
        try (ServletOutputStream output = resp.getOutputStream();){
            this.getWriter((ServletRequest)req).writeValue((OutputStream)output, (Object)this.registry);
        }
    }

    protected ObjectWriter getWriter(ServletRequest request) {
        boolean prettyPrint = Boolean.parseBoolean(request.getParameter("pretty"));
        if (prettyPrint) {
            return this.mapper.writerWithDefaultPrettyPrinter();
        }
        return this.mapper.writer();
    }
}

