/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.eventbus.DeadEvent;
import com.google.common.eventbus.Dispatcher;
import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.EventBusException;
import com.google.common.eventbus.SubscriberExceptionContext;
import com.google.common.eventbus.SubscriberExceptionHandler;
import com.google.common.eventbus.SubscriberRegistry;
import com.google.common.util.concurrent.MoreExecutors;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventBusThatThrowsException
extends EventBus {
    @VisibleForTesting
    final SubscriberExceptionsTrackerHandler exceptionHandler;
    private final SubscriberRegistry subscribers = this.getSubscribers();
    private final Dispatcher dispatcher = this.getDispatcher();

    public EventBusThatThrowsException(String identifier) {
        super(identifier, MoreExecutors.directExecutor(), Dispatcher.immediate(), (SubscriberExceptionHandler)new SubscriberExceptionsTrackerHandler());
        this.exceptionHandler = this.getExceptionHandler();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postWithException(Object event) throws EventBusException {
        Iterator eventSubscribers = this.subscribers.getSubscribers(event);
        if (eventSubscribers.hasNext()) {
            Exception subscriberException;
            this.exceptionHandler.reset();
            RuntimeException guavaException = null;
            try {
                this.dispatcher.dispatch(event, eventSubscribers);
            }
            catch (RuntimeException e) {
                guavaException = e;
            }
            finally {
                subscriberException = this.exceptionHandler.caught();
            }
            if (guavaException != null) {
                throw guavaException;
            }
            if (subscriberException != null) {
                throw new EventBusException(subscriberException);
            }
        } else if (!(event instanceof DeadEvent)) {
            this.post(new DeadEvent((Object)this, event));
        }
    }

    private SubscriberRegistry getSubscribers() {
        return (SubscriberRegistry)this.getDeclaredField("subscribers");
    }

    private Dispatcher getDispatcher() {
        return (Dispatcher)this.getDeclaredField("dispatcher");
    }

    private SubscriberExceptionsTrackerHandler getExceptionHandler() {
        return (SubscriberExceptionsTrackerHandler)this.getDeclaredField("exceptionHandler");
    }

    private <T> T getDeclaredField(String fieldName) {
        try {
            Field f = EventBus.class.getDeclaredField(fieldName);
            f.setAccessible(true);
            return (T)f.get((Object)this);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException("Failed to retrieve private field from BusEvent class " + fieldName, e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed to retrieve private field from BusEvent class " + fieldName, e);
        }
    }

    static final class SubscriberExceptionsTrackerHandler
    implements SubscriberExceptionHandler {
        @VisibleForTesting
        final ThreadLocal<Exception> lastException = new ThreadLocal<Exception>(){};
        private final SubscriberExceptionHandler loggerHandler = EventBus.LoggingHandler.INSTANCE;

        SubscriberExceptionsTrackerHandler() {
        }

        public void handleException(Throwable exception, SubscriberExceptionContext context) {
            if (this.lastException.get() == null) {
                this.lastException.set(new InvocationTargetException(exception));
            }
            this.loggerHandler.handleException(exception, context);
        }

        Exception caught() {
            Exception exception = this.lastException.get();
            this.reset();
            return exception;
        }

        void reset() {
            this.lastException.set(null);
        }
    }
}

