/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.notificationq;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.joda.time.DateTime;
import org.killbill.clock.Clock;
import org.killbill.notificationq.NotificationQueueException;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueConfig;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.notificationq.dao.NotificationEventModelDao;
import org.killbill.notificationq.dao.NotificationSqlDao;
import org.killbill.notificationq.dispatching.NotificationCallableCallback;
import org.killbill.queue.DBBackedQueue;
import org.killbill.queue.DefaultQueueLifecycle;
import org.killbill.queue.dispatching.BlockingRejectionExecutionHandler;
import org.killbill.queue.dispatching.Dispatcher;
import org.skife.jdbi.v2.IDBI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NotificationQueueDispatcher
extends DefaultQueueLifecycle {
    protected static final Logger log = LoggerFactory.getLogger(NotificationQueueDispatcher.class);
    public static final int CLAIM_TIME_MS = 300000;
    private final AtomicLong nbProcessedEvents;
    protected final NotificationQueueConfig config;
    protected final Clock clock;
    protected final Map<String, NotificationQueue> queues;
    protected final DBBackedQueue<NotificationEventModelDao> dao;
    protected final MetricRegistry metricRegistry;
    private final Counter processedNotificationsSinceStart;
    private final Map<String, Histogram> perQueueProcessingTime;
    private final Dispatcher<NotificationEventModelDao> dispatcher;
    private final AtomicBoolean isStarted;

    NotificationQueueDispatcher(Clock clock, final NotificationQueueConfig config, IDBI dbi, MetricRegistry metricRegistry) {
        super("NotificationQ", config);
        ThreadFactory notificationQThreadFactory = new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread th = new Thread(r);
                th.setName(config.getTableName() + "-th");
                th.setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    public void uncaughtException(Thread t, Throwable e) {
                        log.error("Uncaught exception for thread " + t.getName(), e);
                    }
                });
                return th;
            }
        };
        this.clock = clock;
        this.config = config;
        this.nbProcessedEvents = new AtomicLong();
        this.dispatcher = new Dispatcher(1, config.geMaxDispatchThreads(), 10L, TimeUnit.MINUTES, new LinkedBlockingQueue<Runnable>(config.getEventQueueCapacity()), notificationQThreadFactory, new BlockingRejectionExecutionHandler());
        NotificationSqlDao sqlDao = (NotificationSqlDao)dbi.onDemand(NotificationSqlDao.class);
        this.dao = new DBBackedQueue<NotificationEventModelDao>(clock, sqlDao, config, "notif-" + config.getTableName(), metricRegistry, null);
        this.queues = new TreeMap<String, NotificationQueue>();
        this.processedNotificationsSinceStart = metricRegistry.counter(MetricRegistry.name(NotificationQueueDispatcher.class, (String[])new String[]{"processed-notifications-since-start"}));
        this.perQueueProcessingTime = new HashMap<String, Histogram>();
        this.metricRegistry = metricRegistry;
        this.isStarted = new AtomicBoolean(false);
    }

    @Override
    public boolean startQueue() {
        if (this.isStarted.compareAndSet(false, true)) {
            this.dao.initialize();
            this.dispatcher.start();
            super.startQueue();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stopQueue() {
        if (!this.isStarted()) {
            return;
        }
        int nbQueueStarted = 0;
        Map<String, NotificationQueue> map = this.queues;
        synchronized (map) {
            for (NotificationQueue cur : this.queues.values()) {
                if (!cur.isStarted()) continue;
                ++nbQueueStarted;
            }
        }
        if (nbQueueStarted == 0) {
            this.dispatcher.stop();
            super.stopQueue();
            this.isStarted.set(false);
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStarted.get();
    }

    @Override
    public int doProcessEvents() {
        return this.doProcessEventsWithLimit(-1);
    }

    protected int doProcessEventsWithLimit(int limit) {
        this.logDebug("ENTER doProcessEvents", new Object[0]);
        List<NotificationEventModelDao> notifications = this.getReadyNotifications();
        if (notifications.isEmpty()) {
            this.logDebug("EXIT doProcessEvents", new Object[0]);
            return 0;
        }
        this.logDebug("doProcessEventsWithLimit date = %s, got %s", this.getClock().getUTCNow().toDate(), notifications.size());
        if (limit > 0) {
            while (notifications.size() > limit) {
                notifications.remove(notifications.size() - 1);
            }
        }
        for (NotificationEventModelDao cur : notifications) {
            NotificationCallableCallback callback = new NotificationCallableCallback(this);
            this.dispatcher.dispatch(cur, callback);
        }
        return notifications.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleNotificationWithMetrics(NotificationQueueService.NotificationQueueHandler handler, NotificationEventModelDao notification, NotificationEvent key) throws NotificationQueueException {
        String[] parts = notification.getQueueName().split(":");
        String metricName = parts[0].substring(0, 3) + "-" + parts[1] + "-process-time";
        Histogram perQueueHistogramProcessingTime = this.perQueueProcessingTime.get(notification.getQueueName());
        if (perQueueHistogramProcessingTime == null) {
            Map<String, Histogram> map = this.perQueueProcessingTime;
            synchronized (map) {
                if (!this.perQueueProcessingTime.containsKey(notification.getQueueName())) {
                    this.perQueueProcessingTime.put(notification.getQueueName(), this.metricRegistry.histogram(MetricRegistry.name(NotificationQueueDispatcher.class, (String[])new String[]{metricName})));
                }
                perQueueHistogramProcessingTime = this.perQueueProcessingTime.get(notification.getQueueName());
            }
        }
        DateTime beforeProcessing = this.clock.getUTCNow();
        try {
            handler.handleReadyNotification(key, notification.getEffectiveDate(), notification.getFutureUserToken(), notification.getSearchKey1(), notification.getSearchKey2());
        }
        catch (RuntimeException e) {
            throw new NotificationQueueException(e);
        }
        finally {
            this.nbProcessedEvents.incrementAndGet();
            DateTime afterProcessing = this.clock.getUTCNow();
            perQueueHistogramProcessingTime.update(afterProcessing.getMillis() - beforeProcessing.getMillis());
            this.processedNotificationsSinceStart.inc();
        }
    }

    public NotificationQueueService.NotificationQueueHandler getHandlerForActiveQueue(String compositeName) {
        NotificationQueue queue = this.queues.get(compositeName);
        if (queue == null || !queue.isStarted()) {
            return null;
        }
        return queue.getHandler();
    }

    private List<NotificationEventModelDao> getReadyNotifications() {
        List<NotificationEventModelDao> input = this.dao.getReadyEntries();
        ArrayList<NotificationEventModelDao> claimedNotifications = new ArrayList<NotificationEventModelDao>();
        for (NotificationEventModelDao cur : input) {
            NotificationQueue queue = this.queues.get(cur.getQueueName());
            if (queue == null || !queue.isStarted()) continue;
            claimedNotifications.add(cur);
        }
        return claimedNotifications;
    }

    private void logDebug(String format, Object ... args) {
        if (log.isDebugEnabled()) {
            String realDebug = String.format(format, args);
            log.debug(String.format("Thread %d  %s", Thread.currentThread().getId(), realDebug));
        }
    }

    public static String getCompositeName(String svcName, String queueName) {
        return svcName + ":" + queueName;
    }

    public NotificationQueueConfig getConfig() {
        return this.config;
    }

    public Clock getClock() {
        return this.clock;
    }

    public DBBackedQueue<NotificationEventModelDao> getDao() {
        return this.dao;
    }
}

