/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.killbill.commons.concurrent.Executors;
import org.killbill.queue.QueueObjectMapper;
import org.killbill.queue.api.PersistentQueueConfig;
import org.killbill.queue.api.QueueLifecycle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultQueueLifecycle
implements QueueLifecycle {
    public static final String QUEUE_NAME = "Queue";
    private static final Logger log = LoggerFactory.getLogger(DefaultQueueLifecycle.class);
    private static final long ONE_MILLION = 1000000L;
    protected final String svcQName;
    protected final ObjectMapper objectMapper;
    protected final PersistentQueueConfig config;
    private volatile boolean isProcessingEvents;
    private ExecutorService executor;

    public DefaultQueueLifecycle(String svcQName, PersistentQueueConfig config) {
        this(svcQName, config, QueueObjectMapper.get());
    }

    private DefaultQueueLifecycle(String svcQName, PersistentQueueConfig config, ObjectMapper objectMapper) {
        this.svcQName = svcQName;
        this.config = config;
        this.isProcessingEvents = false;
        this.objectMapper = objectMapper;
    }

    public boolean startQueue() {
        this.executor = Executors.newFixedThreadPool((int)1, (String)(this.config.getTableName() + "-lifecycle-th"));
        this.isProcessingEvents = true;
        log.info(String.format("%s: Starting...", this.svcQName));
        this.executor.execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            public void run() {
                log.info(String.format("%s: Thread %s [%d] starting", DefaultQueueLifecycle.this.svcQName, Thread.currentThread().getName(), Thread.currentThread().getId()));
                try {
                    while (DefaultQueueLifecycle.this.isProcessingEvents) {
                        long beforeLoop = System.nanoTime();
                        try {
                            DefaultQueueLifecycle.this.doProcessEvents();
                        }
                        catch (Exception e) {
                            log.warn(String.format("%s: Thread  %s  [%d] got an exception, catching and moving on...", DefaultQueueLifecycle.this.svcQName, Thread.currentThread().getName(), Thread.currentThread().getId()), (Throwable)e);
                        }
                        finally {
                            long afterLoop = System.nanoTime();
                            this.sleepALittle((afterLoop - beforeLoop) / 1000000L);
                        }
                    }
                }
                catch (InterruptedException e) {
                    log.info(String.format("%s: Thread %s got interrupted, exting... ", DefaultQueueLifecycle.this.svcQName, Thread.currentThread().getName()));
                    log.info(String.format("%s: Thread %s has exited", DefaultQueueLifecycle.this.svcQName, Thread.currentThread().getName()));
                }
                catch (Throwable e2) {
                    log.error(String.format("%s: Thread %s got an exception, exting... ", DefaultQueueLifecycle.this.svcQName, Thread.currentThread().getName()), e2);
                    {
                        catch (Throwable throwable) {
                            log.info(String.format("%s: Thread %s has exited", DefaultQueueLifecycle.this.svcQName, Thread.currentThread().getName()));
                            throw throwable;
                        }
                    }
                    log.info(String.format("%s: Thread %s has exited", DefaultQueueLifecycle.this.svcQName, Thread.currentThread().getName()));
                }
                log.info(String.format("%s: Thread %s has exited", DefaultQueueLifecycle.this.svcQName, Thread.currentThread().getName()));
            }

            private void sleepALittle(long loopTimeMsec) throws InterruptedException {
                if (DefaultQueueLifecycle.this.config.getPersistentQueueMode() == PersistentQueueConfig.PersistentQueueMode.STICKY_EVENTS) {
                    return;
                }
                long remainingSleepTime = DefaultQueueLifecycle.this.config.getPollingSleepTimeMs() - loopTimeMsec;
                if (remainingSleepTime > 0L) {
                    Thread.sleep(remainingSleepTime);
                }
            }
        });
        return true;
    }

    public void stopQueue() {
        this.isProcessingEvents = false;
        this.executor.shutdown();
        try {
            this.executor.awaitTermination(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            log.info(String.format("%s: Stop sequence has been interrupted", this.svcQName));
        }
    }

    public abstract int doProcessEvents();

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }
}

