/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue.dao;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Nullable;
import org.killbill.queue.dao.EventEntryModelDao;
import org.killbill.queue.dao.QueueSqlDaoStringTemplate;
import org.killbill.queue.dao.RecordIdCollectionBinder;
import org.skife.jdbi.v2.sqlobject.Bind;
import org.skife.jdbi.v2.sqlobject.BindBean;
import org.skife.jdbi.v2.sqlobject.SqlBatch;
import org.skife.jdbi.v2.sqlobject.SqlQuery;
import org.skife.jdbi.v2.sqlobject.SqlUpdate;
import org.skife.jdbi.v2.sqlobject.customizers.Define;
import org.skife.jdbi.v2.sqlobject.mixins.CloseMe;
import org.skife.jdbi.v2.sqlobject.mixins.Transactional;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@QueueSqlDaoStringTemplate
public interface QueueSqlDao<T extends EventEntryModelDao>
extends Transactional<QueueSqlDao<T>>,
CloseMe {
    @SqlQuery
    public Long getMaxRecordId(@Define(value="tableName") String var1);

    @SqlQuery
    public Long resetLastInsertId();

    @SqlQuery
    public Long getLastInsertId();

    @SqlQuery
    public T getByRecordId(@Bind(value="recordId") Long var1, @Define(value="tableName") String var2);

    @SqlQuery
    public List<T> getEntriesFromIds(@RecordIdCollectionBinder List<Long> var1, @Define(value="tableName") String var2);

    @SqlQuery
    public List<T> getReadyEntries(@Bind(value="now") Date var1, @Bind(value="max") int var2, @Nullable @Define(value="owner") String var3, @Define(value="tableName") String var4);

    @SqlQuery
    public long getNbReadyEntries(@Bind(value="now") Date var1, @Nullable @Define(value="owner") String var2, @Define(value="tableName") String var3);

    @SqlQuery
    public List<T> getInProcessingEntries(@Define(value="tableName") String var1);

    @SqlUpdate
    public int claimEntry(@Bind(value="recordId") Long var1, @Bind(value="now") Date var2, @Bind(value="owner") String var3, @Bind(value="nextAvailable") Date var4, @Define(value="tableName") String var5);

    @SqlUpdate
    public int claimEntries(@RecordIdCollectionBinder Collection<Long> var1, @Bind(value="now") Date var2, @Bind(value="owner") String var3, @Bind(value="nextAvailable") Date var4, @Define(value="tableName") String var5);

    @SqlUpdate
    public int updateOnError(@Bind(value="recordId") Long var1, @Bind(value="now") Date var2, @Bind(value="errorCount") Long var3, @Define(value="tableName") String var4);

    @SqlUpdate
    public void removeEntry(@Bind(value="recordId") Long var1, @Define(value="tableName") String var2);

    @SqlUpdate
    public void removeEntries(@RecordIdCollectionBinder Collection<Long> var1, @Define(value="tableName") String var2);

    @SqlUpdate
    public void insertEntry(@BindBean T var1, @Define(value="tableName") String var2);

    @SqlBatch
    public void insertEntries(@BindBean Iterable<T> var1, @Define(value="tableName") String var2);
}

