/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue.dao;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.killbill.queue.dao.EventEntryModelDao;
import org.killbill.queue.dao.QueueSqlDao;
import org.skife.jdbi.v2.Query;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.SQLStatement;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizer;
import org.skife.jdbi.v2.sqlobject.SqlStatementCustomizingAnnotation;
import org.skife.jdbi.v2.sqlobject.customizers.RegisterMapper;
import org.skife.jdbi.v2.sqlobject.stringtemplate.StringTemplate3StatementLocator;
import org.skife.jdbi.v2.sqlobject.stringtemplate.UseStringTemplate3StatementLocator;
import org.skife.jdbi.v2.tweak.StatementLocator;

@SqlStatementCustomizingAnnotation(value=QueueSqlDaoStringTemplateFactory.class)
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface QueueSqlDaoStringTemplate {
    public static final String DEFAULT_VALUE = " ~ ";

    public String value() default " ~ ";

    public static class QueueSqlDaoStringTemplateFactory
    extends UseStringTemplate3StatementLocator.LocatorFactory {
        static final boolean enableGroupTemplateCaching = Boolean.parseBoolean(System.getProperty("killbill.jdbi.allow.stringTemplateGroupCaching", "true"));
        static final ConcurrentMap<String, StatementLocator> locatorCache = new ConcurrentHashMap<String, StatementLocator>();
        private static final String sep = "/";

        public static String mungify(Class claz) {
            String path = sep + claz.getName();
            return path.replaceAll("\\.", Matcher.quoteReplacement(sep)) + ".sql.stg";
        }

        private static StatementLocator getLocator(String locatorPath) {
            if (enableGroupTemplateCaching && locatorCache.containsKey(locatorPath)) {
                return (StatementLocator)locatorCache.get(locatorPath);
            }
            StringTemplate3StatementLocator.Builder builder = StringTemplate3StatementLocator.builder((String)locatorPath).shouldCache().withSuperGroup(QueueSqlDao.class).allowImplicitTemplateGroup().treatLiteralsAsTemplates();
            StringTemplate3StatementLocator locator = builder.build();
            if (enableGroupTemplateCaching) {
                locatorCache.put(locatorPath, (StatementLocator)locator);
            }
            return locator;
        }

        public SqlStatementCustomizer createForType(Annotation annotation, final Class sqlObjectType) {
            QueueSqlDaoStringTemplate a = (QueueSqlDaoStringTemplate)annotation;
            String locatorPath = QueueSqlDaoStringTemplate.DEFAULT_VALUE.equals(a.value()) ? QueueSqlDaoStringTemplateFactory.mungify(sqlObjectType) : a.value();
            final StatementLocator l = QueueSqlDaoStringTemplateFactory.getLocator(locatorPath);
            return new SqlStatementCustomizer(){

                public void apply(SQLStatement statement) {
                    statement.setStatementLocator(l);
                    if (statement instanceof Query) {
                        Query query = (Query)statement;
                        if (sqlObjectType.getGenericInterfaces() != null && sqlObjectType.getAnnotation(RegisterMapper.class) == null) {
                            for (int i = 0; i < sqlObjectType.getGenericInterfaces().length; ++i) {
                                if (!(sqlObjectType.getGenericInterfaces()[i] instanceof ParameterizedType)) continue;
                                ParameterizedType type = (ParameterizedType)sqlObjectType.getGenericInterfaces()[i];
                                for (int j = 0; j < type.getActualTypeArguments().length; ++j) {
                                    Class modelClazz;
                                    Type modelType = type.getActualTypeArguments()[j];
                                    if (!(modelType instanceof Class) || !EventEntryModelDao.class.isAssignableFrom(modelClazz = (Class)modelType)) continue;
                                    query.registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(modelClazz));
                                }
                            }
                        }
                    }
                }
            };
        }

        public SqlStatementCustomizer createForMethod(Annotation annotation, Class sqlObjectType, Method method) {
            throw new UnsupportedOperationException("Not Defined on Method");
        }

        public SqlStatementCustomizer createForParameter(Annotation annotation, Class sqlObjectType, Method method, Object arg) {
            throw new UnsupportedOperationException("Not defined on parameter");
        }
    }
}

