/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.notificationq.dao;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.killbill.CreatorName;
import org.killbill.TestSetup;
import org.killbill.notificationq.dao.NotificationEventModelDao;
import org.killbill.notificationq.dao.NotificationSqlDao;
import org.killbill.queue.api.PersistentQueueEntryLifecycleState;
import org.killbill.queue.dao.EventEntryModelDao;
import org.killbill.queue.dao.QueueSqlDao;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.Transaction;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestNotificationSqlDao
extends TestSetup {
    private static final String hostname = "Yop";
    private static final long SEARCH_KEY_2 = 37L;
    private NotificationSqlDao dao;

    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        this.dao = (NotificationSqlDao)this.getDBI().onDemand(NotificationSqlDao.class);
    }

    @Test(groups={"slow"}, description="Verify SQL bound arguments are properly serialized")
    public void testQueryGeneratesNoWarning() throws Exception {
        Handle handle = this.getDBI().open();
        try {
            final Date date = new DateTime().toDate();
            handle.inTransaction((TransactionCallback)new TransactionCallback<Object>(){

                public Object inTransaction(Handle conn, TransactionStatus status) throws Exception {
                    NotificationSqlDao notificationSqlDao = (NotificationSqlDao)conn.attach(NotificationSqlDao.class);
                    List entries = notificationSqlDao.getReadyEntries(date, 3, TestNotificationSqlDao.hostname, TestNotificationSqlDao.this.notificationQueueConfig.getTableName());
                    Assert.assertNull((Object)conn.getConnection().getWarnings());
                    Assert.assertEquals((int)entries.size(), (int)0);
                    return null;
                }
            });
        }
        finally {
            handle.close();
        }
    }

    @Test(groups={"slow"})
    public void testBasic() throws InterruptedException {
        long searchKey1 = 1242L;
        String ownerId = UUID.randomUUID().toString();
        String eventJson = UUID.randomUUID().toString();
        DateTime effDt = new DateTime();
        NotificationEventModelDao notif = new NotificationEventModelDao(hostname, this.clock.getUTCNow(), eventJson.getClass().getName(), eventJson, UUID.randomUUID(), Long.valueOf(1242L), Long.valueOf(37L), UUID.randomUUID(), effDt, "testBasic");
        this.dao.insertEntry((EventEntryModelDao)notif, this.notificationQueueConfig.getTableName());
        Thread.sleep(1000L);
        DateTime now = new DateTime();
        List notifications = this.dao.getReadyEntries(now.toDate(), 3, hostname, this.notificationQueueConfig.getTableName());
        Assert.assertNotNull((Object)notifications);
        Assert.assertEquals((int)notifications.size(), (int)1);
        long nbEntries = this.dao.getNbReadyEntries(now.toDate(), hostname, this.notificationQueueConfig.getTableName());
        Assert.assertEquals((long)nbEntries, (long)1L);
        NotificationEventModelDao notification = (NotificationEventModelDao)notifications.get(0);
        Assert.assertEquals((String)notification.getEventJson(), (String)eventJson);
        this.validateDate(notification.getEffectiveDate(), effDt);
        Assert.assertEquals((String)notification.getProcessingOwner(), null);
        Assert.assertEquals((Object)notification.getProcessingState(), (Object)PersistentQueueEntryLifecycleState.AVAILABLE);
        Assert.assertEquals((Object)notification.getNextAvailableDate(), null);
        DateTime nextAvailable = now.plusMinutes(5);
        int res = this.dao.claimEntry(notification.getRecordId(), now.toDate(), ownerId, nextAvailable.toDate(), this.notificationQueueConfig.getTableName());
        Assert.assertEquals((int)res, (int)1);
        this.dao.claimEntry(notification.getRecordId(), now.toDate(), ownerId, nextAvailable.toDate(), this.notificationQueueConfig.getTableName());
        notification = (NotificationEventModelDao)this.dao.getByRecordId(notification.getRecordId(), this.notificationQueueConfig.getTableName());
        Assert.assertEquals((String)notification.getEventJson(), (String)eventJson);
        this.validateDate(notification.getEffectiveDate(), effDt);
        Assert.assertEquals((String)notification.getProcessingOwner(), (String)ownerId);
        Assert.assertEquals((Object)notification.getProcessingState(), (Object)PersistentQueueEntryLifecycleState.IN_PROCESSING);
        this.validateDate(notification.getNextAvailableDate(), nextAvailable);
        DateTime processedTime = this.clock.getUTCNow();
        NotificationEventModelDao notificationHistory = new NotificationEventModelDao(notification, CreatorName.get(), processedTime, PersistentQueueEntryLifecycleState.PROCESSED);
        this.dao.insertEntry((EventEntryModelDao)notificationHistory, this.notificationQueueConfig.getHistoryTableName());
        notificationHistory = (NotificationEventModelDao)this.dao.getByRecordId(notification.getRecordId(), this.notificationQueueConfig.getHistoryTableName());
        Assert.assertEquals((String)notificationHistory.getEventJson(), (String)eventJson);
        this.validateDate(notificationHistory.getEffectiveDate(), effDt);
        Assert.assertEquals((String)notificationHistory.getProcessingOwner(), (String)CreatorName.get());
        Assert.assertEquals((Object)notificationHistory.getProcessingState(), (Object)PersistentQueueEntryLifecycleState.PROCESSED);
        this.validateDate(notificationHistory.getNextAvailableDate(), processedTime);
        this.dao.removeEntry(notification.getRecordId(), this.notificationQueueConfig.getTableName());
        notification = (NotificationEventModelDao)this.dao.getByRecordId(notification.getRecordId(), this.notificationQueueConfig.getTableName());
        Assert.assertNull((Object)notification);
    }

    @Test(groups={"slow"})
    public void testBatchOperations() throws InterruptedException {
        NotificationEventModelDao result;
        long searchKey1 = 1242L;
        String ownerId = UUID.randomUUID().toString();
        String eventJson = UUID.randomUUID().toString();
        DateTime effDt = new DateTime();
        NotificationEventModelDao notif1 = new NotificationEventModelDao(hostname, this.clock.getUTCNow(), eventJson.getClass().getName(), eventJson, UUID.randomUUID(), Long.valueOf(1242L), Long.valueOf(37L), UUID.randomUUID(), effDt, "testBasic1");
        ArrayList<NotificationEventModelDao> entries = new ArrayList<NotificationEventModelDao>();
        notif1 = this.insertEntry(notif1, this.notificationQueueConfig.getTableName());
        entries.add(notif1);
        NotificationEventModelDao notif2 = new NotificationEventModelDao(hostname, this.clock.getUTCNow(), eventJson.getClass().getName(), eventJson, UUID.randomUUID(), Long.valueOf(1242L), Long.valueOf(37L), UUID.randomUUID(), effDt, "testBasic2");
        notif2 = this.insertEntry(notif2, this.notificationQueueConfig.getTableName());
        entries.add(notif2);
        NotificationEventModelDao notif3 = new NotificationEventModelDao(hostname, this.clock.getUTCNow(), eventJson.getClass().getName(), eventJson, UUID.randomUUID(), Long.valueOf(1242L), Long.valueOf(37L), UUID.randomUUID(), effDt, "testBasic3");
        notif3 = this.insertEntry(notif3, this.notificationQueueConfig.getTableName());
        entries.add(notif3);
        Collection entryIds = Collections2.transform(entries, (Function)new Function<NotificationEventModelDao, Long>(){

            @Nullable
            public Long apply(@Nullable NotificationEventModelDao input) {
                return input.getRecordId();
            }
        });
        this.dao.removeEntries(entryIds, this.notificationQueueConfig.getTableName());
        for (Long entry : entryIds) {
            result = (NotificationEventModelDao)this.dao.getByRecordId(entry, this.notificationQueueConfig.getTableName());
            Assert.assertNull((Object)result);
        }
        this.dao.insertEntries(entries, this.notificationQueueConfig.getHistoryTableName());
        for (Long entry : entryIds) {
            result = (NotificationEventModelDao)this.dao.getByRecordId(entry, this.notificationQueueConfig.getHistoryTableName());
            Assert.assertNotNull((Object)result);
        }
    }

    @Test(groups={"slow"})
    public void testUpdateEvent() throws InterruptedException {
        long searchKey1 = 14542L;
        String eventJsonInitial = "Initial value";
        DateTime effDt = new DateTime();
        NotificationEventModelDao notif = new NotificationEventModelDao(hostname, this.clock.getUTCNow(), "Initial value".getClass().getName(), "Initial value", UUID.randomUUID(), Long.valueOf(14542L), Long.valueOf(37L), UUID.randomUUID(), effDt, "testUpdateEvent");
        this.dao.insertEntry((EventEntryModelDao)notif, this.notificationQueueConfig.getTableName());
        Iterator notifications = this.dao.getReadyOrInProcessingQueueEntriesForSearchKeys(notif.getQueueName(), Long.valueOf(14542L), Long.valueOf(37L), this.notificationQueueConfig.getTableName());
        Assert.assertTrue((boolean)notifications.hasNext());
        NotificationEventModelDao notification = (NotificationEventModelDao)notifications.next();
        Assert.assertEquals((String)notification.getEventJson(), (String)"Initial value");
        Assert.assertFalse((boolean)notifications.hasNext());
        String eventJsonUpdated = "Updated value";
        this.dao.updateEntry(notification.getRecordId(), "Updated value", Long.valueOf(14542L), Long.valueOf(37L), this.notificationQueueConfig.getTableName());
        notifications = this.dao.getReadyOrInProcessingQueueEntriesForSearchKeys(notif.getQueueName(), Long.valueOf(14542L), Long.valueOf(37L), this.notificationQueueConfig.getTableName());
        Assert.assertTrue((boolean)notifications.hasNext());
        NotificationEventModelDao updatedNotification = (NotificationEventModelDao)notifications.next();
        Assert.assertEquals((String)updatedNotification.getEventJson(), (String)"Updated value");
        Assert.assertFalse((boolean)notifications.hasNext());
    }

    private NotificationEventModelDao insertEntry(final NotificationEventModelDao input, final String tableName) {
        return (NotificationEventModelDao)this.dao.inTransaction((Transaction)new Transaction<NotificationEventModelDao, QueueSqlDao<NotificationEventModelDao>>(){

            public NotificationEventModelDao inTransaction(QueueSqlDao<NotificationEventModelDao> transactional, TransactionStatus status) throws Exception {
                transactional.insertEntry((EventEntryModelDao)input, tableName);
                return (NotificationEventModelDao)transactional.getByRecordId(transactional.getLastInsertId(), TestNotificationSqlDao.this.notificationQueueConfig.getTableName());
            }
        });
    }

    private void validateDate(DateTime input, DateTime expected) {
        if (input == null && expected != null) {
            Assert.fail((String)"Got input date null");
        }
        if (input != null && expected == null) {
            Assert.fail((String)"Was expecting null date");
        }
        expected = this.truncateAndUTC(expected);
        input = this.truncateAndUTC(input);
        Assert.assertEquals((Object)input, (Object)expected);
    }

    private DateTime truncateAndUTC(DateTime input) {
        if (input == null) {
            return null;
        }
        DateTime result = input.minus((long)input.getMillisOfSecond());
        return result.toDateTime(DateTimeZone.UTC);
    }
}

