/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.bus;

import com.google.common.eventbus.EventBusException;
import com.google.common.eventbus.EventBusThatThrowsException;
import java.sql.Connection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.killbill.bus.api.BusEvent;
import org.killbill.bus.api.BusEventWithMetadata;
import org.killbill.bus.api.PersistentBus;
import org.killbill.bus.api.PersistentBusConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InMemoryPersistentBus
implements PersistentBus {
    private static final Logger log = LoggerFactory.getLogger(InMemoryPersistentBus.class);
    private final EventBusDelegate delegate;
    private final AtomicBoolean isInitialized;

    @Override
    public boolean startQueue() {
        return true;
    }

    @Override
    public void stopQueue() {
    }

    @Override
    public boolean isStarted() {
        return true;
    }

    @Inject
    public InMemoryPersistentBus(PersistentBusConfig config) {
        ThreadGroup group = new ThreadGroup("bus-grp");
        this.delegate = new EventBusDelegate();
        this.isInitialized = new AtomicBoolean(false);
    }

    @Override
    public void register(Object handlerInstance) throws PersistentBus.EventBusException {
        this.checkInitialized("register");
        this.delegate.register(handlerInstance);
    }

    @Override
    public void unregister(Object handlerInstance) throws PersistentBus.EventBusException {
        this.checkInitialized("unregister");
        this.delegate.unregister(handlerInstance);
    }

    @Override
    public void post(BusEvent event) throws PersistentBus.EventBusException {
        this.checkInitialized("post");
        try {
            this.delegate.postWithException(event);
        }
        catch (EventBusException e) {
            throw new PersistentBus.EventBusException(e.getMessage(), e);
        }
    }

    @Override
    public void postFromTransaction(BusEvent event, Connection connection) throws PersistentBus.EventBusException {
        this.checkInitialized("postFromTransaction");
        try {
            this.delegate.postWithException(event);
        }
        catch (EventBusException e) {
            throw new PersistentBus.EventBusException(e.getMessage(), e);
        }
    }

    @Override
    public void start() {
        if (this.isInitialized.compareAndSet(false, true)) {
            log.info("InMemoryPersistentBus started...");
        }
    }

    private void checkInitialized(String operation) throws PersistentBus.EventBusException {
        if (!this.isInitialized.get()) {
            throw new PersistentBus.EventBusException(String.format("Attempting operation %s on an non initialized bus", operation));
        }
    }

    @Override
    public void stop() {
        if (this.isInitialized.compareAndSet(true, false)) {
            log.info("InMemoryPersistentBus stopping...");
            this.delegate.completeDispatch();
            this.delegate.stop();
            log.info("InMemoryPersistentBus stopped...");
        }
    }

    public <T extends BusEvent> List<BusEventWithMetadata<T>> getAvailableBusEventsForSearchKeys(Long searchKey1, Long searchKey2) {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    public <T extends BusEvent> List<BusEventWithMetadata<T>> getAvailableBusEventsFromTransactionForSearchKeys(Long searchKey1, Long searchKey2, Connection connection) {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    public <T extends BusEvent> List<BusEventWithMetadata<T>> getAvailableBusEventsForSearchKey2(DateTime maxCreatedDate, Long searchKey2) {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    public <T extends BusEvent> List<BusEventWithMetadata<T>> getAvailableBusEventsFromTransactionForSearchKey2(DateTime maxCreatedDate, Long searchKey2, Connection connection) {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    public <T extends BusEvent> List<BusEventWithMetadata<T>> getInProcessingBusEvents() {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    public <T extends BusEvent> List<BusEventWithMetadata<T>> getAvailableOrInProcessingBusEventsForSearchKeys(Long searchKey1, Long searchKey2) {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    public <T extends BusEvent> List<BusEventWithMetadata<T>> getAvailableOrInProcessingBusEventsFromTransactionForSearchKeys(Long searchKey1, Long searchKey2, Connection connection) {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    public <T extends BusEvent> List<BusEventWithMetadata<T>> getAvailableOrInProcessingBusEventsForSearchKey2(DateTime maxCreatedDate, Long searchKey2) {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    public <T extends BusEvent> List<BusEventWithMetadata<T>> getAvailableOrInProcessingBusEventsFromTransactionForSearchKey2(DateTime maxCreatedDate, Long searchKey2, Connection connection) {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    public <T extends BusEvent> List<BusEventWithMetadata<T>> getHistoricalBusEventsForSearchKeys(Long searchKey1, Long searchKey2) {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    public <T extends BusEvent> List<BusEventWithMetadata<T>> getHistoricalBusEventsForSearchKey2(DateTime minCreatedDate, Long searchKey2) {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    @Override
    public long getNbReadyEntries(DateTime maxCreatedDate) {
        throw new UnsupportedOperationException("Guava doesn't expose the events to dispatch");
    }

    public class EventBusDelegate
    extends EventBusThatThrowsException {
        public EventBusDelegate() {
            super("Bus");
        }

        public void completeDispatch() {
        }

        public void stop() {
        }
    }
}

