/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.bus.dao;

import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.queue.api.PersistentQueueEntryLifecycleState;
import org.killbill.queue.dao.EventEntryModelDao;

public class BusEventModelDao
implements EventEntryModelDao {
    private Long recordId;
    private String className;
    private String eventJson;
    private UUID userToken;
    private DateTime createdDate;
    private String creatingOwner;
    private String processingOwner;
    private DateTime processingAvailableDate;
    private Long errorCount;
    private PersistentQueueEntryLifecycleState processingState;
    private Long searchKey1;
    private Long searchKey2;

    public BusEventModelDao() {
    }

    public BusEventModelDao(Long recordId, String createdOwner, String owner, DateTime createdDate, DateTime nextAvailable, PersistentQueueEntryLifecycleState processingState, String busEventClass, String busEventJson, Long errorCount, UUID userToken, Long searchKey1, Long searchKey2) {
        this.recordId = recordId;
        this.creatingOwner = createdOwner;
        this.processingOwner = owner;
        this.createdDate = createdDate;
        this.processingAvailableDate = nextAvailable;
        this.processingState = processingState;
        this.className = busEventClass;
        this.errorCount = errorCount;
        this.eventJson = busEventJson;
        this.userToken = userToken;
        this.searchKey1 = searchKey1;
        this.searchKey2 = searchKey2;
    }

    public BusEventModelDao(String createdOwner, DateTime createdDate, String busEventClass, String busEventJson, UUID userToken, Long searchKey1, Long searchKey2) {
        this(-1L, createdOwner, null, createdDate, null, PersistentQueueEntryLifecycleState.AVAILABLE, busEventClass, busEventJson, 0L, userToken, searchKey1, searchKey2);
    }

    public BusEventModelDao(BusEventModelDao in, String owner, DateTime nextAvailable, PersistentQueueEntryLifecycleState state) {
        this(in.getRecordId(), in.getCreatingOwner(), owner, in.getCreatedDate(), nextAvailable, state, in.getClassName(), in.getEventJson(), in.getErrorCount(), in.getUserToken(), in.getSearchKey1(), in.getSearchKey2());
    }

    public BusEventModelDao(BusEventModelDao in, String owner, DateTime nextAvailable, PersistentQueueEntryLifecycleState state, Long errorCount) {
        this(in.getRecordId(), in.getCreatingOwner(), owner, in.getCreatedDate(), nextAvailable, state, in.getClassName(), in.getEventJson(), errorCount, in.getUserToken(), in.getSearchKey1(), in.getSearchKey2());
    }

    public Long getRecordId() {
        return this.recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getEventJson() {
        return this.eventJson;
    }

    public void setEventJson(String eventJson) {
        this.eventJson = eventJson;
    }

    public UUID getUserToken() {
        return this.userToken;
    }

    public void setUserToken(UUID userToken) {
        this.userToken = userToken;
    }

    public DateTime getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(DateTime createdDate) {
        this.createdDate = createdDate;
    }

    public String getCreatingOwner() {
        return this.creatingOwner;
    }

    public void setCreatingOwner(String creatingOwner) {
        this.creatingOwner = creatingOwner;
    }

    public String getProcessingOwner() {
        return this.processingOwner;
    }

    public void setProcessingOwner(String processingOwner) {
        this.processingOwner = processingOwner;
    }

    public DateTime getNextAvailableDate() {
        return this.processingAvailableDate;
    }

    public DateTime getProcessingAvailableDate() {
        return this.processingAvailableDate;
    }

    public void setProcessingAvailableDate(DateTime processingAvailableDate) {
        this.processingAvailableDate = processingAvailableDate;
    }

    public void setErrorCount(Long errorCount) {
        this.errorCount = errorCount;
    }

    public PersistentQueueEntryLifecycleState getProcessingState() {
        return this.processingState;
    }

    public void setProcessingState(PersistentQueueEntryLifecycleState processingState) {
        this.processingState = processingState;
    }

    public void setSearchKey1(Long searchKey1) {
        this.searchKey1 = searchKey1;
    }

    public void setSearchKey2(Long searchKey2) {
        this.searchKey2 = searchKey2;
    }

    public boolean isAvailableForProcessing(DateTime now) {
        switch (this.processingState) {
            case AVAILABLE: {
                break;
            }
            case IN_PROCESSING: {
                if (!this.processingAvailableDate.isAfter((ReadableInstant)now)) break;
                return false;
            }
            case PROCESSED: {
                return false;
            }
            default: {
                throw new RuntimeException(String.format("Unknown IEvent processing state %s", new Object[]{this.processingState}));
            }
        }
        return true;
    }

    public Long getErrorCount() {
        return this.errorCount;
    }

    public Long getSearchKey1() {
        return this.searchKey1;
    }

    public Long getSearchKey2() {
        return this.searchKey2;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BusEventModelDao{");
        sb.append("recordId=").append(this.recordId);
        sb.append(", className='").append(this.className).append('\'');
        sb.append(", eventJson='").append(this.eventJson).append('\'');
        sb.append(", userToken=").append(this.userToken);
        sb.append(", createdDate=").append(this.createdDate);
        sb.append(", creatingOwner='").append(this.creatingOwner).append('\'');
        sb.append(", processingOwner='").append(this.processingOwner).append('\'');
        sb.append(", processingAvailableDate=").append(this.processingAvailableDate);
        sb.append(", errorCount=").append(this.errorCount);
        sb.append(", processingState=").append((Object)this.processingState);
        sb.append(", searchKey1=").append(this.searchKey1);
        sb.append(", searchKey2=").append(this.searchKey2);
        sb.append('}');
        return sb.toString();
    }
}

