/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.notificationq;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Function;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.io.IOException;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.killbill.CreatorName;
import org.killbill.clock.Clock;
import org.killbill.commons.profiling.Profiling;
import org.killbill.commons.profiling.ProfilingFeature;
import org.killbill.notificationq.NotificationQueueServiceBase;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationEventWithMetadata;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueConfig;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.notificationq.dao.NotificationEventModelDao;
import org.killbill.notificationq.dao.NotificationSqlDao;
import org.killbill.queue.DBBackedQueue;
import org.killbill.queue.InTransaction;
import org.killbill.queue.QueueObjectMapper;
import org.killbill.queue.api.PersistentQueueEntryLifecycleState;
import org.killbill.queue.dao.QueueSqlDao;
import org.killbill.queue.dispatching.CallableCallbackBase;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Transaction;
import org.skife.jdbi.v2.TransactionStatus;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultNotificationQueue
implements NotificationQueue {
    private static final Logger logger = LoggerFactory.getLogger(DefaultNotificationQueue.class);
    private final DBI dbi;
    private final DBBackedQueue<NotificationEventModelDao> dao;
    private final String svcName;
    private final String queueName;
    private final NotificationQueueService.NotificationQueueHandler handler;
    private final NotificationQueueService notificationQueueService;
    private final ObjectMapper objectMapper;
    private final Clock clock;
    private final NotificationQueueConfig config;
    private final Profiling<Iterable<NotificationEventModelDao>, RuntimeException> prof;
    private volatile boolean isStarted;

    public DefaultNotificationQueue(String svcName, String queueName, NotificationQueueService.NotificationQueueHandler handler, DBI dbi, DBBackedQueue<NotificationEventModelDao> dao, NotificationQueueService notificationQueueService, Clock clock, NotificationQueueConfig config) {
        this(svcName, queueName, handler, dbi, dao, notificationQueueService, clock, config, QueueObjectMapper.get());
    }

    public DefaultNotificationQueue(String svcName, String queueName, NotificationQueueService.NotificationQueueHandler handler, DBI dbi, DBBackedQueue<NotificationEventModelDao> dao, NotificationQueueService notificationQueueService, Clock clock, NotificationQueueConfig config, ObjectMapper objectMapper) {
        this.dbi = dbi;
        this.svcName = svcName;
        this.queueName = queueName;
        this.handler = handler;
        this.dao = dao;
        this.notificationQueueService = notificationQueueService;
        this.objectMapper = objectMapper;
        this.clock = clock;
        this.config = config;
        this.prof = new Profiling();
    }

    @Override
    public void recordFutureNotification(DateTime futureNotificationTime, NotificationEvent event, UUID userToken, Long searchKey1, Long searchKey2) throws IOException {
        String eventJson = this.objectMapper.writeValueAsString((Object)event);
        UUID futureUserToken = UUID.randomUUID();
        Long searchKey2WithNull = (Long)MoreObjects.firstNonNull((Object)searchKey2, (Object)new Long(0L));
        NotificationEventModelDao notification = new NotificationEventModelDao(CreatorName.get(), this.clock.getUTCNow(), event.getClass().getName(), eventJson, userToken, searchKey1, searchKey2WithNull, futureUserToken, futureNotificationTime, this.getFullQName());
        this.dao.insertEntry(notification);
    }

    @Override
    public void recordFutureNotificationFromTransaction(Connection connection, DateTime futureNotificationTime, NotificationEvent event, UUID userToken, Long searchKey1, Long searchKey2) throws IOException {
        String eventJson = this.objectMapper.writeValueAsString((Object)event);
        UUID futureUserToken = UUID.randomUUID();
        Long searchKey2WithNull = (Long)MoreObjects.firstNonNull((Object)searchKey2, (Object)0L);
        final NotificationEventModelDao notification = new NotificationEventModelDao(CreatorName.get(), this.clock.getUTCNow(), event.getClass().getName(), eventJson, userToken, searchKey1, searchKey2WithNull, futureUserToken, futureNotificationTime, this.getFullQName());
        InTransaction.InTransactionHandler<NotificationSqlDao, Void> handler = new InTransaction.InTransactionHandler<NotificationSqlDao, Void>(){

            @Override
            public Void withSqlDao(NotificationSqlDao transactional) throws Exception {
                DefaultNotificationQueue.this.dao.insertEntryFromTransaction(transactional, notification);
                return null;
            }
        };
        InTransaction.execute(this.dbi, connection, handler, NotificationSqlDao.class);
    }

    @Override
    public void updateFutureNotification(Long recordId, NotificationEvent event, Long searchKey1, Long searchKey2) throws IOException {
        String eventJson = this.objectMapper.writeValueAsString((Object)event);
        Long searchKey2WithNull = (Long)MoreObjects.firstNonNull((Object)searchKey2, (Object)0L);
        ((NotificationSqlDao)this.dao.getSqlDao()).updateEntry(recordId, eventJson, searchKey1, searchKey2WithNull, this.config.getTableName());
    }

    @Override
    public void updateFutureNotificationFromTransaction(Connection connection, final Long recordId, NotificationEvent event, final Long searchKey1, Long searchKey2) throws IOException {
        final String eventJson = this.objectMapper.writeValueAsString((Object)event);
        final Long searchKey2WithNull = (Long)MoreObjects.firstNonNull((Object)searchKey2, (Object)0L);
        InTransaction.InTransactionHandler<NotificationSqlDao, Void> handler = new InTransaction.InTransactionHandler<NotificationSqlDao, Void>(){

            @Override
            public Void withSqlDao(NotificationSqlDao transactional) throws Exception {
                ((NotificationSqlDao)DefaultNotificationQueue.this.dao.getSqlDao()).updateEntry(recordId, eventJson, searchKey1, searchKey2WithNull, DefaultNotificationQueue.this.config.getTableName());
                return null;
            }
        };
        InTransaction.execute(this.dbi, connection, handler, NotificationSqlDao.class);
    }

    @Override
    public <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getFutureNotificationForSearchKeys(Long searchKey1, Long searchKey2) {
        return this.getFutureNotificationsInternal((NotificationSqlDao)this.dao.getSqlDao(), null, searchKey1, searchKey2);
    }

    @Override
    public <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getFutureNotificationFromTransactionForSearchKeys(final Long searchKey1, final Long searchKey2, Connection connection) {
        InTransaction.InTransactionHandler handler = new InTransaction.InTransactionHandler<NotificationSqlDao, Iterable<NotificationEventWithMetadata<T>>>(){

            @Override
            public Iterable<NotificationEventWithMetadata<T>> withSqlDao(NotificationSqlDao transactional) throws Exception {
                return DefaultNotificationQueue.this.getFutureNotificationsInternal(transactional, null, searchKey1, searchKey2);
            }
        };
        return (Iterable)InTransaction.execute(this.dbi, connection, handler, NotificationSqlDao.class);
    }

    @Override
    public <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getFutureNotificationForSearchKey2(DateTime maxEffectiveDate, Long searchKey2) {
        return this.getFutureNotificationsInternal((NotificationSqlDao)this.dao.getSqlDao(), maxEffectiveDate, null, searchKey2);
    }

    @Override
    public <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getFutureNotificationFromTransactionForSearchKey2(final DateTime maxEffectiveDate, final Long searchKey2, Connection connection) {
        InTransaction.InTransactionHandler handler = new InTransaction.InTransactionHandler<NotificationSqlDao, Iterable<NotificationEventWithMetadata<T>>>(){

            @Override
            public Iterable<NotificationEventWithMetadata<T>> withSqlDao(NotificationSqlDao transactional) throws Exception {
                return DefaultNotificationQueue.this.getFutureNotificationsInternal(transactional, maxEffectiveDate, null, searchKey2);
            }
        };
        return (Iterable)InTransaction.execute(this.dbi, connection, handler, NotificationSqlDao.class);
    }

    @Override
    public <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getInProcessingNotifications() {
        return this.toNotificationEventWithMetadata(this.dao.getSqlDao().getInProcessingEntries(this.config.getTableName()));
    }

    @Override
    public <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getFutureOrInProcessingNotificationForSearchKeys(Long searchKey1, Long searchKey2) {
        return this.getFutureOrInProcessingNotificationsInternal((NotificationSqlDao)this.dao.getSqlDao(), null, searchKey1, searchKey2);
    }

    @Override
    public <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getFutureOrInProcessingNotificationFromTransactionForSearchKeys(final Long searchKey1, final Long searchKey2, Connection connection) {
        InTransaction.InTransactionHandler handler = new InTransaction.InTransactionHandler<NotificationSqlDao, Iterable<NotificationEventWithMetadata<T>>>(){

            @Override
            public Iterable<NotificationEventWithMetadata<T>> withSqlDao(NotificationSqlDao transactional) throws Exception {
                return DefaultNotificationQueue.this.getFutureOrInProcessingNotificationsInternal(transactional, null, searchKey1, searchKey2);
            }
        };
        return (Iterable)InTransaction.execute(this.dbi, connection, handler, NotificationSqlDao.class);
    }

    @Override
    public <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getFutureOrInProcessingNotificationForSearchKey2(DateTime maxEffectiveDate, Long searchKey2) {
        return this.getFutureOrInProcessingNotificationsInternal((NotificationSqlDao)this.dao.getSqlDao(), maxEffectiveDate, null, searchKey2);
    }

    @Override
    public <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getFutureOrInProcessingNotificationFromTransactionForSearchKey2(final DateTime maxEffectiveDate, final Long searchKey2, Connection connection) {
        InTransaction.InTransactionHandler handler = new InTransaction.InTransactionHandler<NotificationSqlDao, Iterable<NotificationEventWithMetadata<T>>>(){

            @Override
            public Iterable<NotificationEventWithMetadata<T>> withSqlDao(NotificationSqlDao transactional) throws Exception {
                return DefaultNotificationQueue.this.getFutureOrInProcessingNotificationsInternal(transactional, maxEffectiveDate, null, searchKey2);
            }
        };
        return (Iterable)InTransaction.execute(this.dbi, connection, handler, NotificationSqlDao.class);
    }

    @Override
    public <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getHistoricalNotificationForSearchKeys(Long searchKey1, Long searchKey2) {
        return this.getHistoricalNotificationsInternal((NotificationSqlDao)this.dao.getSqlDao(), null, searchKey1, searchKey2);
    }

    @Override
    public <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getHistoricalNotificationForSearchKey2(DateTime minEffectiveDate, Long searchKey2) {
        return this.getHistoricalNotificationsInternal((NotificationSqlDao)this.dao.getSqlDao(), minEffectiveDate, null, searchKey2);
    }

    private <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getFutureNotificationsInternal(NotificationSqlDao transactionalDao, @Nullable DateTime maxEffectiveDate, @Nullable Long searchKey1, Long searchKey2) {
        Iterable<NotificationEventModelDao> entries = this.getFutureNotificationsInternalWithProfiling(transactionalDao, maxEffectiveDate, searchKey1, searchKey2);
        return this.toNotificationEventWithMetadata(entries);
    }

    private <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getFutureOrInProcessingNotificationsInternal(NotificationSqlDao transactionalDao, @Nullable DateTime maxEffectiveDate, @Nullable Long searchKey1, Long searchKey2) {
        Iterable<NotificationEventModelDao> entries = this.getFutureOrInProcessingNotificationsInternalWithProfiling(transactionalDao, maxEffectiveDate, searchKey1, searchKey2);
        return this.toNotificationEventWithMetadata(entries);
    }

    private <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> getHistoricalNotificationsInternal(NotificationSqlDao transactionalDao, @Nullable DateTime minEffectiveDate, @Nullable Long searchKey1, Long searchKey2) {
        Iterable<NotificationEventModelDao> entries = this.getHistoricalNotificationsInternalWithProfiling(transactionalDao, minEffectiveDate, searchKey1, searchKey2);
        return this.toNotificationEventWithMetadata(entries);
    }

    private Iterable<NotificationEventModelDao> getFutureNotificationsInternalWithProfiling(final NotificationSqlDao transactionalDao, final @Nullable DateTime maxEffectiveDate, final @Nullable Long searchKey1, final Long searchKey2) {
        return (Iterable)this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO, "DAO:NotificationSqlDao:getReadyQueueEntriesForSearchKeys", (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Iterable<NotificationEventModelDao>, RuntimeException>(){

            public Iterable<NotificationEventModelDao> execute() throws RuntimeException {
                return new Iterable<NotificationEventModelDao>(){

                    @Override
                    public Iterator<NotificationEventModelDao> iterator() {
                        return searchKey1 != null ? transactionalDao.getReadyQueueEntriesForSearchKeys(DefaultNotificationQueue.this.getFullQName(), searchKey1, searchKey2, DefaultNotificationQueue.this.config.getTableName()) : transactionalDao.getReadyQueueEntriesForSearchKey2(DefaultNotificationQueue.this.getFullQName(), maxEffectiveDate, searchKey2, DefaultNotificationQueue.this.config.getTableName());
                    }
                };
            }
        });
    }

    private Iterable<NotificationEventModelDao> getFutureOrInProcessingNotificationsInternalWithProfiling(final NotificationSqlDao transactionalDao, final @Nullable DateTime maxEffectiveDate, final @Nullable Long searchKey1, final Long searchKey2) {
        return (Iterable)this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO, "DAO:NotificationSqlDao:getReadyOrInProcessingQueueEntriesForSearchKeys", (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Iterable<NotificationEventModelDao>, RuntimeException>(){

            public Iterable<NotificationEventModelDao> execute() throws RuntimeException {
                return new Iterable<NotificationEventModelDao>(){

                    @Override
                    public Iterator<NotificationEventModelDao> iterator() {
                        return searchKey1 != null ? transactionalDao.getReadyOrInProcessingQueueEntriesForSearchKeys(DefaultNotificationQueue.this.getFullQName(), searchKey1, searchKey2, DefaultNotificationQueue.this.config.getTableName()) : transactionalDao.getReadyOrInProcessingQueueEntriesForSearchKey2(DefaultNotificationQueue.this.getFullQName(), maxEffectiveDate, searchKey2, DefaultNotificationQueue.this.config.getTableName());
                    }
                };
            }
        });
    }

    private Iterable<NotificationEventModelDao> getHistoricalNotificationsInternalWithProfiling(final NotificationSqlDao transactionalDao, final @Nullable DateTime minEffectiveDate, final @Nullable Long searchKey1, final Long searchKey2) {
        return (Iterable)this.prof.executeWithProfiling(ProfilingFeature.ProfilingFeatureType.DAO, "DAO:NotificationSqlDao:getHistoricalQueueEntriesForSearchKeys", (Profiling.WithProfilingCallback)new Profiling.WithProfilingCallback<Iterable<NotificationEventModelDao>, RuntimeException>(){

            public Iterable<NotificationEventModelDao> execute() throws RuntimeException {
                return new Iterable<NotificationEventModelDao>(){

                    @Override
                    public Iterator<NotificationEventModelDao> iterator() {
                        return searchKey1 != null ? transactionalDao.getHistoricalQueueEntriesForSearchKeys(DefaultNotificationQueue.this.getFullQName(), searchKey1, searchKey2, DefaultNotificationQueue.this.config.getHistoryTableName()) : transactionalDao.getHistoricalQueueEntriesForSearchKey2(DefaultNotificationQueue.this.getFullQName(), minEffectiveDate, searchKey2, DefaultNotificationQueue.this.config.getHistoryTableName());
                    }
                };
            }
        });
    }

    private <T extends NotificationEvent> Iterable<NotificationEventWithMetadata<T>> toNotificationEventWithMetadata(Iterable<NotificationEventModelDao> entries) {
        return Iterables.transform(entries, (Function)new Function<NotificationEventModelDao, NotificationEventWithMetadata<T>>(){

            public NotificationEventWithMetadata<T> apply(NotificationEventModelDao input) {
                return DefaultNotificationQueue.this.toNotificationEventWithMetadata(input);
            }
        });
    }

    private <T extends NotificationEvent> NotificationEventWithMetadata<T> toNotificationEventWithMetadata(NotificationEventModelDao cur) {
        NotificationEvent event = (NotificationEvent)CallableCallbackBase.deserializeEvent(cur, this.objectMapper);
        return new NotificationEventWithMetadata<NotificationEvent>(cur.getRecordId(), cur.getUserToken(), cur.getCreatedDate(), cur.getSearchKey1(), cur.getSearchKey2(), event, cur.getFutureUserToken(), cur.getEffectiveDate(), cur.getQueueName());
    }

    @Override
    public long getNbReadyEntries(DateTime maxCreatedDate) {
        return this.dao.getNbReadyEntries(maxCreatedDate.toDate());
    }

    @Override
    public void removeNotification(Long recordId) {
        NotificationEventModelDao existing = this.dao.getSqlDao().getByRecordId(recordId, this.config.getTableName());
        NotificationEventModelDao removedEntry = new NotificationEventModelDao(existing, CreatorName.get(), this.clock.getUTCNow(), PersistentQueueEntryLifecycleState.REMOVED);
        this.dao.moveEntryToHistory(removedEntry);
    }

    @Override
    public void removeNotificationFromTransaction(Connection connection, final Long recordId) {
        InTransaction.InTransactionHandler<NotificationSqlDao, Void> handler = new InTransaction.InTransactionHandler<NotificationSqlDao, Void>(){

            @Override
            public Void withSqlDao(NotificationSqlDao transactional) throws Exception {
                NotificationEventModelDao existing = (NotificationEventModelDao)transactional.getByRecordId(recordId, DefaultNotificationQueue.this.config.getTableName());
                NotificationEventModelDao removedEntry = new NotificationEventModelDao(existing, CreatorName.get(), DefaultNotificationQueue.this.clock.getUTCNow(), PersistentQueueEntryLifecycleState.REMOVED);
                DefaultNotificationQueue.this.dao.moveEntryToHistoryFromTransaction(transactional, removedEntry);
                return null;
            }
        };
        InTransaction.execute(this.dbi, connection, handler, NotificationSqlDao.class);
    }

    @Override
    public void removeFutureNotificationsForSearchKeys(final Long searchKey1, final Long searchKey2) {
        this.dao.getSqlDao().inTransaction((Transaction)new Transaction<Void, QueueSqlDao<NotificationEventModelDao>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Void inTransaction(QueueSqlDao<NotificationEventModelDao> transactional, TransactionStatus status) throws Exception {
                int batchSize = 25;
                ArrayList<NotificationEventModelDao> currentBatch = new ArrayList<NotificationEventModelDao>(25);
                Iterator<NotificationEventModelDao> futureQueueEntriesForSearchKeys = ((NotificationSqlDao)transactional).getReadyQueueEntriesForSearchKeys(DefaultNotificationQueue.this.getFullQName(), searchKey1, searchKey2, DefaultNotificationQueue.this.config.getTableName());
                try {
                    while (futureQueueEntriesForSearchKeys.hasNext()) {
                        NotificationEventModelDao notificationEventModelDao = futureQueueEntriesForSearchKeys.next();
                        notificationEventModelDao.setProcessingState(PersistentQueueEntryLifecycleState.REMOVED);
                        currentBatch.add(notificationEventModelDao);
                        if (currentBatch.size() < 25 && futureQueueEntriesForSearchKeys.hasNext()) continue;
                        DefaultNotificationQueue.this.dao.moveEntriesToHistoryFromTransaction(transactional, currentBatch);
                        currentBatch.clear();
                    }
                }
                finally {
                    int nbNotificationsLeft = Iterators.size(futureQueueEntriesForSearchKeys);
                    if (nbNotificationsLeft > 0) {
                        logger.warn("Unable to remove {} notifications for searchKey1={}, searchKey2={}", (Object)searchKey1, (Object)searchKey2);
                    }
                }
                return null;
            }
        });
    }

    @Override
    public String getFullQName() {
        return NotificationQueueServiceBase.getCompositeName(this.svcName, this.queueName);
    }

    @Override
    public String getServiceName() {
        return this.svcName;
    }

    @Override
    public String getQueueName() {
        return this.queueName;
    }

    @Override
    public NotificationQueueService.NotificationQueueHandler getHandler() {
        return this.handler;
    }

    @Override
    public boolean startQueue() {
        if (this.config.isProcessingOff()) {
            return false;
        }
        this.notificationQueueService.startQueue();
        this.isStarted = true;
        return true;
    }

    @Override
    public void stopQueue() {
        this.isStarted = false;
        this.notificationQueueService.stopQueue();
    }

    @Override
    public boolean isStarted() {
        return this.isStarted;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultNotificationQueue{");
        sb.append("svcName='").append(this.svcName).append('\'');
        sb.append(", queueName='").append(this.queueName).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

