/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.notificationq;

import com.codahale.metrics.MetricRegistry;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import javax.sql.DataSource;
import org.killbill.clock.Clock;
import org.killbill.clock.DefaultClock;
import org.killbill.notificationq.DefaultNotificationQueue;
import org.killbill.notificationq.NotificationQueueServiceBase;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueConfig;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.queue.InTransaction;
import org.skife.config.ConfigSource;
import org.skife.config.ConfigurationObjectFactory;
import org.skife.config.SimplePropertyConfigSource;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.IDBI;

public class DefaultNotificationQueueService
extends NotificationQueueServiceBase {
    private final DBI dbi;

    @Inject
    public DefaultNotificationQueueService(@Named(value="Queue") IDBI idbi, Clock clock, NotificationQueueConfig config, MetricRegistry metricRegistry) {
        super(clock, config, idbi, metricRegistry);
        this.dbi = (DBI)idbi;
    }

    public DefaultNotificationQueueService(DataSource dataSource, Properties properties) {
        this((IDBI)InTransaction.buildDDBI(dataSource), (Clock)new DefaultClock(), (NotificationQueueConfig)new ConfigurationObjectFactory((ConfigSource)new SimplePropertyConfigSource(properties)).buildWithReplacements(NotificationQueueConfig.class, (Map)ImmutableMap.of((Object)"instanceName", (Object)"main")), new MetricRegistry());
    }

    protected NotificationQueue createNotificationQueueInternal(String svcName, String queueName, NotificationQueueService.NotificationQueueHandler handler) {
        return new DefaultNotificationQueue(svcName, queueName, handler, this.dbi, this.dao, this, this.clock, this.config);
    }
}

