/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue.dispatching;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.joda.time.DateTime;
import org.killbill.clock.Clock;
import org.killbill.queue.DBBackedQueue;
import org.killbill.queue.api.PersistentQueueConfig;
import org.killbill.queue.api.PersistentQueueEntryLifecycleState;
import org.killbill.queue.api.QueueEvent;
import org.killbill.queue.dao.EventEntryModelDao;
import org.killbill.queue.dispatching.CallableCallback;
import org.killbill.queue.retry.RetryableInternalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CallableCallbackBase<E extends QueueEvent, M extends EventEntryModelDao>
implements CallableCallback<E, M> {
    private static final Logger log = LoggerFactory.getLogger(CallableCallbackBase.class);
    private final DBBackedQueue<M> dao;
    private final Clock clock;
    private final PersistentQueueConfig config;
    private final ObjectMapper objectMapper;

    public CallableCallbackBase(DBBackedQueue<M> dao, Clock clock, PersistentQueueConfig config, ObjectMapper objectMapper) {
        this.dao = dao;
        this.clock = clock;
        this.config = config;
        this.objectMapper = objectMapper;
    }

    @Override
    public E deserialize(M modelDao) {
        return CallableCallbackBase.deserializeEvent(modelDao, this.objectMapper);
    }

    public static <E extends QueueEvent, M extends EventEntryModelDao> E deserializeEvent(M modelDao, ObjectMapper objectMapper) {
        try {
            Class<?> claz = Class.forName(modelDao.getClassName());
            return (E)((QueueEvent)objectMapper.readValue(modelDao.getEventJson(), claz));
        }
        catch (Exception e) {
            log.error(String.format("Failed to deserialize json object %s for class %s", modelDao.getEventJson(), modelDao.getClassName()), (Throwable)e);
            return null;
        }
    }

    @Override
    public abstract void dispatch(E var1, M var2) throws Exception;

    public abstract M buildEntry(M var1, DateTime var2, PersistentQueueEntryLifecycleState var3, long var4);

    @Override
    public void updateErrorCountOrMoveToHistory(E event, M modelDao, long errorCount, Throwable lastException) {
        if (lastException == null) {
            this.moveSuccessfulEventToHistory(modelDao);
            if (log.isDebugEnabled()) {
                log.debug("Done handling notification {}, key = {}", (Object)modelDao.getRecordId(), (Object)modelDao.getEventJson());
            }
        } else if (lastException instanceof RetryableInternalException) {
            this.moveFailedEventToHistory(modelDao);
        } else if (errorCount <= (long)this.config.getMaxFailureRetries()) {
            log.info("Dispatch error, will attempt a retry ", lastException);
            this.updateRetryCountForFailedEvent(modelDao, errorCount);
        } else {
            log.error("Fatal NotificationQ dispatch error, data corruption...", lastException);
            this.moveFailedEventToHistory(modelDao);
        }
    }

    private void moveSuccessfulEventToHistory(M input) {
        M newEntry = this.buildEntry(input, this.clock.getUTCNow(), PersistentQueueEntryLifecycleState.PROCESSED, input.getErrorCount());
        this.dao.moveEntryToHistory(newEntry);
    }

    private void updateRetryCountForFailedEvent(M input, long errorCount) {
        M newEntry = this.buildEntry(input, this.clock.getUTCNow(), PersistentQueueEntryLifecycleState.AVAILABLE, errorCount);
        this.dao.updateOnError(newEntry);
    }

    private void moveFailedEventToHistory(M input) {
        M newEntry = this.buildEntry(input, this.clock.getUTCNow(), PersistentQueueEntryLifecycleState.FAILED, input.getErrorCount());
        this.dao.moveEntryToHistory(newEntry);
    }
}

