/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue.retry;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableSet;
import com.google.common.reflect.TypeToken;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.bus.api.BusEvent;
import org.killbill.clock.Clock;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.queue.retry.RetryableHandler;
import org.killbill.queue.retry.RetryableService;
import org.killbill.queue.retry.SubscriberNotificationEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryableSubscriber
extends RetryableHandler {
    private static final Logger log = LoggerFactory.getLogger(RetryableSubscriber.class);

    public RetryableSubscriber(Clock clock, RetryableService retryableService, NotificationQueueService.NotificationQueueHandler handlerDelegate) {
        super(clock, retryableService, handlerDelegate);
    }

    public void handleEvent(BusEvent event) {
        this.handleReadyNotification(new SubscriberNotificationEvent(event, event.getClass()), this.clock.getUTCNow(), event.getUserToken(), event.getSearchKey1(), event.getSearchKey2());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SubscriberQueueHandler
    implements NotificationQueueService.NotificationQueueHandler {
        private static final LoadingCache<Class<?>, ImmutableSet<Class<?>>> FLATTEN_HIERARCHY_CACHE = CacheBuilder.newBuilder().build(new CacheLoader<Class<?>, ImmutableSet<Class<?>>>(){

            public ImmutableSet<Class<?>> load(Class<?> concreteClass) {
                return ImmutableSet.copyOf((Collection)TypeToken.of(concreteClass).getTypes().rawTypes());
            }
        });
        private final Map<Class<?>, SubscriberAction<? extends BusEvent>> actions = new HashMap();

        public <B extends BusEvent> void subscribe(Class<B> busEventClass, SubscriberAction<B> action) {
            this.actions.put(busEventClass, action);
        }

        @Override
        public void handleReadyNotification(NotificationEvent eventJson, DateTime eventDateTime, UUID userToken, Long searchKey1, Long searchKey2) {
            if (!(eventJson instanceof SubscriberNotificationEvent)) {
                log.error("SubscriberQueueHandler received an unexpected event className='{}'", eventJson.getClass());
            } else {
                BusEvent busEvent = ((SubscriberNotificationEvent)eventJson).getBusEvent();
                ImmutableSet eventTypes = (ImmutableSet)FLATTEN_HIERARCHY_CACHE.getUnchecked(busEvent.getClass());
                for (Class eventType : eventTypes) {
                    SubscriberAction<? extends BusEvent> next = this.actions.get(eventType);
                    if (next == null) continue;
                    next.run(busEvent);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface SubscriberAction<T extends BusEvent> {
        public void run(T var1);
    }
}

