/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue.retry;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.notificationq.api.NotificationEvent;

public class RetryNotificationEvent
implements NotificationEvent {
    private final String originalEvent;
    private final Class originalEventClass;
    private final DateTime originalEffectiveDate;
    private final int retryNb;

    @JsonCreator
    public RetryNotificationEvent(@JsonProperty(value="originalEvent") String originalEvent, @JsonProperty(value="originalEventClass") Class originalEventClass, @JsonProperty(value="originalEffectiveDate") DateTime originalEffectiveDate, @JsonProperty(value="retryNb") int retryNb) {
        this.originalEvent = originalEvent;
        this.originalEventClass = originalEventClass;
        this.originalEffectiveDate = originalEffectiveDate;
        this.retryNb = retryNb;
    }

    public String getOriginalEvent() {
        return this.originalEvent;
    }

    public Class getOriginalEventClass() {
        return this.originalEventClass;
    }

    public DateTime getOriginalEffectiveDate() {
        return this.originalEffectiveDate;
    }

    public int getRetryNb() {
        return this.retryNb;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("RetryNotificationEvent{");
        sb.append("originalEvent=").append(this.originalEvent);
        sb.append(", originalEventClass=").append(this.originalEventClass);
        sb.append(", originalEffectiveDate=").append(this.originalEffectiveDate);
        sb.append(", retryNb=").append(this.retryNb);
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RetryNotificationEvent that = (RetryNotificationEvent)o;
        if (this.retryNb != that.retryNb) {
            return false;
        }
        if (this.originalEvent != null ? !this.originalEvent.equals(that.originalEvent) : that.originalEvent != null) {
            return false;
        }
        if (this.originalEventClass != null ? !this.originalEventClass.equals(that.originalEventClass) : that.originalEventClass != null) {
            return false;
        }
        return this.originalEffectiveDate != null ? this.originalEffectiveDate.compareTo((ReadableInstant)that.originalEffectiveDate) == 0 : that.originalEffectiveDate == null;
    }

    public int hashCode() {
        int result = this.originalEvent != null ? this.originalEvent.hashCode() : 0;
        result = 31 * result + (this.originalEventClass != null ? this.originalEventClass.hashCode() : 0);
        result = 31 * result + (this.originalEffectiveDate != null ? this.originalEffectiveDate.hashCode() : 0);
        result = 31 * result + this.retryNb;
        return result;
    }
}

