/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue.retry;

import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.util.queue.QueueRetryException;
import org.killbill.clock.Clock;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.queue.retry.RetryableService;

public class RetryableHandler
implements NotificationQueueService.NotificationQueueHandler {
    protected final Clock clock;
    private final RetryableService retryableService;
    private final NotificationQueueService.NotificationQueueHandler handlerDelegate;

    public RetryableHandler(Clock clock, RetryableService retryableService, NotificationQueueService.NotificationQueueHandler handlerDelegate) {
        this.clock = clock;
        this.retryableService = retryableService;
        this.handlerDelegate = handlerDelegate;
    }

    @Override
    public void handleReadyNotification(NotificationEvent notificationEvent, DateTime eventDateTime, UUID userToken, Long searchKey1, Long searchKey2) {
        try {
            this.handlerDelegate.handleReadyNotification(notificationEvent, eventDateTime, userToken, searchKey1, searchKey2);
        }
        catch (QueueRetryException e) {
            this.retryableService.scheduleRetry(e, notificationEvent, eventDateTime, userToken, searchKey1, searchKey2, 1);
        }
    }
}

