/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import javax.sql.DataSource;
import org.killbill.bus.dao.BusEventModelDao;
import org.killbill.commons.jdbi.argument.DateTimeArgumentFactory;
import org.killbill.commons.jdbi.argument.DateTimeZoneArgumentFactory;
import org.killbill.commons.jdbi.argument.LocalDateArgumentFactory;
import org.killbill.commons.jdbi.argument.UUIDArgumentFactory;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.killbill.commons.jdbi.mapper.UUIDMapper;
import org.killbill.notificationq.dao.NotificationEventModelDao;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.tweak.ArgumentFactory;
import org.skife.jdbi.v2.tweak.ConnectionFactory;
import org.skife.jdbi.v2.tweak.ResultSetMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InTransaction {
    private static final Logger logger = LoggerFactory.getLogger(InTransaction.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <K, R> R execute(DBI dbi, Connection connection, InTransactionHandler<K, R> handler, Class<K> klass) {
        R r;
        Handle handle = dbi.open((ConnectionFactory)new ConnectionFactoryWithDelegate(connection));
        try {
            Object transactional = handle.attach(klass);
            r = handler.withSqlDao(transactional);
        }
        catch (Exception e) {
            logger.error("Failed to process transaction", (Throwable)e);
            R r2 = null;
            return r2;
        }
        return r;
    }

    public static DBI buildDDBI(Connection connection) {
        DataSourceWithDelegate dataSource = new DataSourceWithDelegate(connection);
        return InTransaction.buildDDBI(dataSource);
    }

    public static DBI buildDDBI(DataSource dataSource) {
        DBI dbi = new DBI(dataSource);
        InTransaction.setupDBI(dbi);
        return dbi;
    }

    @VisibleForTesting
    public static void setupDBI(DBI dbi) {
        dbi.registerArgumentFactory((ArgumentFactory)new UUIDArgumentFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new DateTimeZoneArgumentFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new DateTimeArgumentFactory());
        dbi.registerArgumentFactory((ArgumentFactory)new LocalDateArgumentFactory());
        dbi.registerMapper((ResultSetMapper)new UUIDMapper());
        dbi.registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(BusEventModelDao.class));
        dbi.registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(NotificationEventModelDao.class));
    }

    private static final class ConnectionFactoryWithDelegate
    implements ConnectionFactory {
        private final Connection connection;

        public ConnectionFactoryWithDelegate(Connection connection) {
            this.connection = connection;
        }

        public Connection openConnection() throws SQLException {
            return this.connection;
        }
    }

    private static final class DataSourceWithDelegate
    implements DataSource {
        private final Connection connection;

        public DataSourceWithDelegate(Connection connection) {
            this.connection = connection;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.connection;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            return this.connection;
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }
    }

    public static interface InTransactionHandler<K, R> {
        public R withSqlDao(K var1) throws Exception;
    }
}

