/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue;

import java.util.Date;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.killbill.clock.Clock;
import org.killbill.commons.concurrent.Executors;
import org.killbill.queue.DBBackedQueue;
import org.killbill.queue.api.PersistentQueueConfig;
import org.killbill.queue.api.Reaper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DefaultReaper
implements Reaper {
    static final long ONE_MINUTES_IN_MSEC = 60000L;
    static final long FIVE_MINUTES_IN_MSEC = 300000L;
    private final DBBackedQueue<?> dao;
    private final PersistentQueueConfig config;
    private final Clock clock;
    private final AtomicBoolean isStarted;
    private final String threadScheduledExecutorName;
    private ScheduledFuture<?> reapEntriesHandle;
    private static final Logger log = LoggerFactory.getLogger(DefaultReaper.class);
    private ScheduledExecutorService scheduler;

    public DefaultReaper(DBBackedQueue<?> dao, PersistentQueueConfig config, Clock clock, String threadScheduledExecutorName) {
        this.dao = dao;
        this.config = config;
        this.clock = clock;
        this.isStarted = new AtomicBoolean(false);
        this.threadScheduledExecutorName = threadScheduledExecutorName;
    }

    @Override
    public void start() {
        if (!this.isStarted.compareAndSet(false, true)) {
            return;
        }
        final long reapThresholdMillis = this.getReapThreshold();
        long schedulePeriodMillis = this.config.getReapSchedule().getMillis();
        log.info("{}: Starting... reapThresholdMillis={}, schedulePeriodMillis={}", new Object[]{this.threadScheduledExecutorName, reapThresholdMillis, schedulePeriodMillis});
        Runnable reapEntries = new Runnable(){

            @Override
            public void run() {
                DefaultReaper.this.dao.reapEntries(this.getReapingDate());
            }

            private Date getReapingDate() {
                return DefaultReaper.this.clock.getUTCNow().minusMillis((int)reapThresholdMillis).toDate();
            }
        };
        this.scheduler = Executors.newSingleThreadScheduledExecutor((String)this.threadScheduledExecutorName);
        this.reapEntriesHandle = this.scheduler.scheduleWithFixedDelay(reapEntries, schedulePeriodMillis, schedulePeriodMillis, TimeUnit.MILLISECONDS);
    }

    @Override
    public void stop() {
        if (!this.isStarted.compareAndSet(true, false)) {
            return;
        }
        log.info("{}: Shutdown...", (Object)this.threadScheduledExecutorName);
        if (!this.reapEntriesHandle.isCancelled() || !this.reapEntriesHandle.isDone()) {
            this.reapEntriesHandle.cancel(true);
        }
        if (!this.scheduler.isShutdown()) {
            this.scheduler.shutdown();
            try {
                this.scheduler.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                log.info("{} stop sequence has been interrupted", (Object)this.threadScheduledExecutorName);
                Thread.currentThread().interrupt();
            }
        }
    }

    @Override
    public boolean isStarted() {
        return this.isStarted.get();
    }

    long getReapThreshold() {
        long threshold;
        if (this.config.getClaimedTime().getMillis() >= this.config.getReapThreshold().getMillis()) {
            threshold = this.config.getClaimedTime().getMillis() + 300000L;
            log.warn("{}: Reap threshold was mis-configured. Claim time [{}] is greater than reap threshold [{}]", new Object[]{this.threadScheduledExecutorName, this.config.getClaimedTime().toString(), this.config.getReapThreshold().toString()});
        } else {
            threshold = this.config.getReapThreshold().getMillis();
        }
        return threshold;
    }
}

