/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.eventbus;

import com.google.common.eventbus.EventBusException;
import com.google.common.eventbus.TestSetupEventBusThatThrowsException;
import java.lang.reflect.InvocationTargetException;
import java.util.UUID;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestEventBusThatThrowsException
extends TestSetupEventBusThatThrowsException {
    @BeforeMethod(groups={"fast"})
    public void setUp() throws Exception {
        this.busSetup();
    }

    @AfterMethod(groups={"fast"})
    public void tearDown() throws Exception {
        Assert.assertNull(this.eventBus.exceptionHandler.lastException.get());
    }

    @Test(groups={"fast"})
    public void testThrowFirstExceptionFromSubscribersV1() throws Exception {
        TestSetupEventBusThatThrowsException.MyEvent event = new TestSetupEventBusThatThrowsException.MyEvent(UUID.randomUUID(), "A");
        try {
            this.eventBus.postWithException((Object)event);
            Assert.fail();
        }
        catch (EventBusException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvocationTargetException));
            Assert.assertTrue((boolean)(e.getCause().getCause() instanceof RuntimeException));
            Assert.assertEquals((String)e.getCause().getCause().getMessage(), (String)TestSetupEventBusThatThrowsException.Subscriber.exceptionMarker("A"));
        }
        this.checkEventsSeen(this.subscriberA, new TestSetupEventBusThatThrowsException.MyEvent[0]);
        this.checkEventsSeen(this.subscriberB, event);
    }

    @Test(groups={"fast"})
    public void testThrowFirstExceptionFromSubscribersV2() throws Exception {
        TestSetupEventBusThatThrowsException.MyEvent event = new TestSetupEventBusThatThrowsException.MyEvent(UUID.randomUUID(), "B");
        try {
            this.eventBus.postWithException((Object)event);
            Assert.fail();
        }
        catch (EventBusException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvocationTargetException));
            Assert.assertTrue((boolean)(e.getCause().getCause() instanceof RuntimeException));
            Assert.assertEquals((String)e.getCause().getCause().getMessage(), (String)TestSetupEventBusThatThrowsException.Subscriber.exceptionMarker("B"));
        }
        this.checkEventsSeen(this.subscriberA, event);
        this.checkEventsSeen(this.subscriberB, new TestSetupEventBusThatThrowsException.MyEvent[0]);
    }

    @Test(groups={"fast"})
    public void testThrowFirstExceptionFromSubscribersV3() throws Exception {
        TestSetupEventBusThatThrowsException.MyEvent event = new TestSetupEventBusThatThrowsException.MyEvent(UUID.randomUUID(), "A", "B");
        try {
            this.eventBus.postWithException((Object)event);
            Assert.fail();
        }
        catch (EventBusException e) {
            Assert.assertTrue((boolean)(e.getCause() instanceof InvocationTargetException));
            Assert.assertTrue((boolean)(e.getCause().getCause() instanceof RuntimeException));
            Assert.assertEquals((String)e.getCause().getCause().getMessage(), (String)TestSetupEventBusThatThrowsException.Subscriber.exceptionMarker("A"));
        }
        this.checkEventsSeen(this.subscriberA, new TestSetupEventBusThatThrowsException.MyEvent[0]);
        this.checkEventsSeen(this.subscriberB, new TestSetupEventBusThatThrowsException.MyEvent[0]);
    }
}

