/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.bus.dao;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.killbill.TestSetup;
import org.killbill.bus.dao.BusEventModelDao;
import org.killbill.bus.dao.PersistentBusSqlDao;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestBusSqlDao
extends TestSetup {
    private static final String hostname = "Hip";
    private static final long SEARCH_KEY_2 = 39L;
    private PersistentBusSqlDao dao;

    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        super.beforeClass();
        this.dao = (PersistentBusSqlDao)this.getDBI().onDemand(PersistentBusSqlDao.class);
    }

    @Test(groups={"slow"})
    public void testGetReadyEntryIds() {
        long searchKey1 = 1242L;
        int TOTAL_ENTRIES = 1543;
        ArrayList<BusEventModelDao> entries = new ArrayList<BusEventModelDao>(1543);
        for (int i = 0; i < 1543; ++i) {
            String eventJson = String.valueOf(i);
            BusEventModelDao e = new BusEventModelDao(hostname, this.clock.getUTCNow(), eventJson.getClass().toString(), eventJson, UUID.randomUUID(), Long.valueOf(1242L), Long.valueOf(39L));
            entries.add(e);
        }
        this.dao.insertEntries(entries, this.persistentBusConfig.getTableName());
        int remaining = 1543;
        int BATCH_SIZE = 100;
        int totalEntries = 0;
        long fromRecordId = -1L;
        while (remaining > 0) {
            List curBatch = this.dao.getReadyEntryIds(this.clock.getUTCNow().toDate(), fromRecordId, 100, hostname, this.persistentBusConfig.getTableName());
            if (remaining / 100 > 0) {
                Assert.assertEquals((int)curBatch.size(), (int)100);
            } else {
                Assert.assertEquals((int)curBatch.size(), (int)remaining);
            }
            for (Long e : curBatch) {
                if (fromRecordId == -1L) {
                    fromRecordId = e;
                } else {
                    Assert.assertEquals((long)e, (long)fromRecordId);
                }
                ++fromRecordId;
            }
            remaining -= curBatch.size();
            totalEntries += curBatch.size();
        }
        Assert.assertEquals((int)totalEntries, (int)1543);
    }
}

