/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.queue.retry;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;
import org.killbill.billing.util.queue.QueueRetryException;
import org.killbill.notificationq.api.NotificationEvent;
import org.killbill.notificationq.api.NotificationQueue;
import org.killbill.notificationq.api.NotificationQueueService;
import org.killbill.queue.QueueObjectMapper;
import org.killbill.queue.api.QueueEvent;
import org.killbill.queue.retry.RetryNotificationEvent;
import org.killbill.queue.retry.RetryableInternalException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RetryableService {
    public static final String RETRYABLE_SERVICE_NAME = "notifications-retries";
    private static final Logger log = LoggerFactory.getLogger(RetryableService.class);
    private final ObjectMapper objectMapper;
    private final NotificationQueueService notificationQueueService;
    private NotificationQueue retryNotificationQueue;

    public RetryableService(NotificationQueueService notificationQueueService) {
        this(notificationQueueService, QueueObjectMapper.get());
    }

    public RetryableService(NotificationQueueService notificationQueueService, ObjectMapper objectMapper) {
        this.notificationQueueService = notificationQueueService;
        this.objectMapper = objectMapper;
    }

    public void initialize(NotificationQueue originalQueue, NotificationQueueService.NotificationQueueHandler originalQueueHandler) {
        this.initialize(originalQueue.getQueueName(), originalQueueHandler);
    }

    public void initialize(String queueName, final NotificationQueueService.NotificationQueueHandler originalQueueHandler) {
        try {
            NotificationQueueService.NotificationQueueHandler notificationQueueHandler = new NotificationQueueService.NotificationQueueHandler(){

                @Override
                public void handleReadyNotification(NotificationEvent eventJson, DateTime eventDateTime, UUID userToken, Long searchKey1, Long searchKey2) {
                    if (eventJson instanceof RetryNotificationEvent) {
                        NotificationEvent notificationEvent;
                        RetryNotificationEvent retryNotificationEvent = (RetryNotificationEvent)eventJson;
                        try {
                            notificationEvent = (NotificationEvent)RetryableService.this.objectMapper.readValue(retryNotificationEvent.getOriginalEvent(), retryNotificationEvent.getOriginalEventClass());
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                        try {
                            originalQueueHandler.handleReadyNotification(notificationEvent, eventDateTime, userToken, searchKey1, searchKey2);
                        }
                        catch (QueueRetryException e) {
                            RetryableService.this.scheduleRetry(e, notificationEvent, retryNotificationEvent.getOriginalEffectiveDate(), userToken, searchKey1, searchKey2, retryNotificationEvent.getRetryNb() + 1);
                        }
                    } else {
                        log.error("Retry service received an unexpected event className='{}'", eventJson.getClass());
                    }
                }
            };
            this.retryNotificationQueue = this.notificationQueueService.createNotificationQueue(RETRYABLE_SERVICE_NAME, queueName, notificationQueueHandler);
        }
        catch (NotificationQueueService.NotificationQueueAlreadyExists notificationQueueAlreadyExists) {
            throw new RuntimeException(notificationQueueAlreadyExists);
        }
    }

    public void start() {
        this.retryNotificationQueue.startQueue();
    }

    public void stop() throws NotificationQueueService.NoSuchNotificationQueue {
        if (this.retryNotificationQueue != null) {
            this.retryNotificationQueue.stopQueue();
            this.notificationQueueService.deleteNotificationQueue(this.retryNotificationQueue.getServiceName(), this.retryNotificationQueue.getQueueName());
        }
    }

    public void scheduleRetry(QueueRetryException exception, QueueEvent originalNotificationEvent, DateTime originalEffectiveDate, UUID userToken, Long searchKey1, Long searchKey2, int retryNb) {
        DateTime effectiveDate = this.computeRetryDate(exception, originalEffectiveDate, retryNb);
        if (effectiveDate == null) {
            log.warn("Error processing event, NOT scheduling retry for event='{}', retryNb='{}'", new Object[]{originalNotificationEvent, retryNb, exception});
            throw new RetryableInternalException(false);
        }
        log.warn("Error processing event, scheduling retry for event='{}', effectiveDate='{}', retryNb='{}'", new Object[]{originalNotificationEvent, effectiveDate, retryNb, exception});
        try {
            RetryNotificationEvent retryNotificationEvent = new RetryNotificationEvent(this.objectMapper.writeValueAsString((Object)originalNotificationEvent), originalNotificationEvent.getClass(), originalEffectiveDate, retryNb);
            this.retryNotificationQueue.recordFutureNotification(effectiveDate, retryNotificationEvent, userToken, searchKey1, searchKey2);
            throw new RetryableInternalException(true);
        }
        catch (IOException e) {
            log.error("Unable to schedule retry for event='{}', effectiveDate='{}'", new Object[]{originalNotificationEvent, effectiveDate, e});
            throw new RetryableInternalException(false);
        }
    }

    private DateTime computeRetryDate(QueueRetryException queueRetryException, DateTime initialEventDateTime, int retryNb) {
        List retrySchedule = queueRetryException.getRetrySchedule();
        if (retrySchedule == null || retryNb > retrySchedule.size()) {
            return null;
        }
        Period nextDelay = (Period)retrySchedule.get(retryNb - 1);
        return initialEventDateTime.plus((ReadablePeriod)nextDelay);
    }
}

